% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_structure.R
\name{flsgen_structure}
\alias{flsgen_structure}
\title{Landscape structure generator}
\usage{
flsgen_structure(
  targets_str,
  targets_file,
  nb_solutions = 1,
  time_limit = 0,
  search_strategy = "DEFAULT"
)
}
\arguments{
\item{targets_str}{JSON-formatted string describing user targets}

\item{targets_file}{JSON file describing user targets}

\item{nb_solutions}{Number of solutions to generate}

\item{time_limit}{Time limit in seconds (if time_limit = 0, no time limit is set)}

\item{search_strategy}{Choco solver search strategy (for more details refer to Choco solver documentation:
\url{https://choco-solver.org/docs/})}
}
\value{
A vector of JSON-formatted landscape structures satisfying user targets.
}
\description{
Generate landscape structures satisfying user targets
}
\details{
The input user targets must be either specified as a JSON-formatted string
 (targets_str parameter) or as a JSON file (target_file parameter)
}
\examples{
  \dontrun{
    json <- "{
      \"nbRows\" : 200,
      \"nbCols\" : 200,
        {
          \"name\" : \"Class A\",
          \"NP\" : [1, 10],
          \"AREA\" : [300, 4000],
          \"CA\" : [1000, 5000],
          \"MESH\" : [225, 225]
        },
        {
          \"name\" : \"Class B\",
          \"NP\" : [2, 8],
          \"AREA\" : [200, 4000],
          \"PLAND\" : [40, 40]
        },
        {
          \"name\" : \"Class C\",
           \"NP\" : [5, 7],
           \"AREA\" : [800, 1200]
        }
      ]
    }"
    structure <- flsgen_structure(targets_str = json)
  }
}
