/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.learn;

import java.util.Comparator;
import java.util.HashMap;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.Implications;
import org.chocosolver.solver.learn.XParameters;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.objects.ValueSortedMap;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class LazyImplications
extends Implications {
    Entry[] entries;
    final HashMap<IntVar, Entry> rootEntries;
    private final IStateInt size;
    private int nbEntries = 0;
    private boolean tagDl;

    LazyImplications(Model model) {
        this.size = model.getEnvironment().makeInt(0);
        this.size._set(0, 0);
        this.entries = new Entry[16];
        this.rootEntries = new HashMap(16, 0.5f);
        this.init(model);
    }

    @Override
    public void init(Model model) {
        IntVar[] ivars;
        for (IntVar var : ivars = model.retrieveIntVars(true)) {
            this.ensureCapacity();
            Entry root = this.entries[this.nbEntries] = new Entry();
            root.set(var, Cause.Null, IntEventType.VOID.getMask(), 0, this.nbEntries, this.nbEntries, 1);
            root.getD().copyFrom(var);
            root.d.lock();
            var.createLit(root.d);
            this.rootEntries.put(var, root);
            ++this.nbEntries;
        }
        this.size.set(this.nbEntries);
    }

    @Override
    public void reset() {
        this.synchronize(this.rootEntries.size());
    }

    private boolean checkIntegrity() {
        for (Entry r : this.rootEntries.values()) {
            int dec;
            Entry prev = this.entries[r.p];
            if (prev.i > dec) {
                return false;
            }
            for (dec = this.nbEntries; dec > 0 && prev != r; --dec) {
                prev = this.entries[prev.p];
            }
            if (dec != 0) continue;
            return false;
        }
        return true;
    }

    private void synchronize(int upto) {
        for (int p = upto; p < this.nbEntries; ++p) {
            Entry e = this.entries[p];
            e.getD().unlock();
            Entry root = this.rootEntries.get(e.v);
            if (root.p < upto) continue;
            root.setPrev(e.p);
        }
        this.nbEntries = upto;
        assert (!XParameters.DEBUG_INTEGRITY || this.checkIntegrity());
    }

    @Override
    public void tagDecisionLevel() {
        this.tagDl = true;
    }

    @Override
    public void undoLastEvent() {
        Entry toUndo = this.entries[--this.nbEntries];
        this.rootEntries.get((Object)toUndo.v).p = toUndo.p;
    }

    private void ensureCapacity() {
        if (this.nbEntries >= this.entries.length) {
            int oldCapacity = this.entries.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            Entry[] entBigger = new Entry[newCapacity];
            System.arraycopy(this.entries, 0, entBigger, 0, oldCapacity);
            this.entries = entBigger;
        }
    }

    private boolean mergeConditions(Entry prev, ICause cause) {
        switch (0) {
            default: {
                return false;
            }
            case 1: 
        }
        return this.nbEntries - 1 == prev.i && cause == prev.c;
    }

    private void mergeEntry(IntEventType evt, int one, Entry nentry) {
        nentry.m |= evt.getMask();
        nentry.getD().unlock();
        LazyImplications.mergeDomain(nentry.getD(), evt, one);
        nentry.getD().lock();
    }

    private static void mergeDomain(IntIterableRangeSet dom, IntEventType mask, int one) {
        switch (mask) {
            case VOID: 
            case BOUND: {
                throw new Error("Unknown case " + mask);
            }
            case INSTANTIATE: {
                dom.retainBetween(one, one);
                break;
            }
            case REMOVE: {
                dom.remove(one);
                break;
            }
            case INCLOW: {
                dom.removeBetween(dom.min(), one - 1);
                break;
            }
            case DECUPP: {
                dom.removeBetween(one + 1, dom.max());
            }
        }
    }

    private static void createDomain(IntIterableRangeSet to, IntIterableRangeSet from, IntEventType mask, int one) {
        switch (mask) {
            case VOID: 
            case BOUND: {
                throw new Error("Unknown case VOID");
            }
            case REMOVE: {
                IntIterableSetUtils.unionOf(to, from);
                to.remove(one);
                break;
            }
            case INCLOW: {
                IntIterableSetUtils.intersection(to, from, one, from.max());
                break;
            }
            case DECUPP: {
                IntIterableSetUtils.intersection(to, from, from.min(), one);
                break;
            }
            case INSTANTIATE: {
                IntIterableSetUtils.intersection(to, from, one, one);
            }
        }
    }

    private void addEntry(IntVar var, ICause cause, IntEventType evt, int one, Entry root, Entry prev) {
        this.ensureCapacity();
        Entry nentry = this.entries[this.nbEntries];
        if (nentry == null) {
            nentry = this.entries[this.nbEntries] = new Entry();
        } else {
            nentry.getD().clear();
        }
        int dl = this.entries[this.nbEntries - 1].dl;
        if (this.tagDl) {
            this.tagDl = false;
            ++dl;
        }
        nentry.set(var, cause, evt.getMask(), one, this.nbEntries, prev.i, dl);
        LazyImplications.createDomain(nentry.getD(), prev.d, evt, one);
        nentry.getD().lock();
        root.setPrev(this.nbEntries);
        this.size.add(1);
        ++this.nbEntries;
    }

    @Override
    public void pushEvent(IntVar var, ICause cause, IntEventType evt, int one, int two, int three) {
        Entry root;
        int size_ = this.size.get();
        if (this.nbEntries != size_) {
            this.synchronize(size_);
        }
        if ((root = this.rootEntries.get(var)) == null) {
            throw new Error("Unknown variable. This happens when a constraint is added after the call to `solver.setLearningClause();`");
        }
        int pidx = root.p;
        Entry prev = this.entries[pidx];
        assert (prev != null);
        assert (prev.v == var);
        if (this.mergeConditions(prev, cause)) {
            this.mergeEntry(evt, one, prev);
        } else {
            this.addEntry(var, cause, evt, one, root, prev);
        }
        assert (!XParameters.DEBUG_INTEGRITY || this.checkIntegrity());
    }

    int rightmostNode(int limit, IntVar var) {
        int pos;
        if (var.isBool()) {
            Entry root = this.rootEntries.get(var);
            int ri = root.i;
            assert (ri < limit) : "impossible right-most search";
            if (root.p >= limit) {
                root = this.entries[root.p];
            }
            return root.p < limit ? root.p : ri;
        }
        int prev = this.rootEntries.get((Object)var).p;
        for (pos = limit - 1; pos > 0 && this.entries[pos].v != var && prev > limit; --pos) {
            prev = this.entries[prev].p;
        }
        return prev > limit ? pos : prev;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public void collectNodesFromConflict(ContradictionException cft, ValueSortedMap<IntVar> front) {
        if (cft.v != null) {
            Entry root = this.rootEntries.get(cft.v);
            assert (this.entries[root.p].c == cft.c);
            front.put((IntVar)cft.v, root.p);
        } else {
            cft.c.forEachIntVar(v -> {
                Entry root = this.rootEntries.get(v);
                front.put(root.v, root.p);
            });
        }
    }

    @Override
    public void predecessorsOf(int p, ValueSortedMap<IntVar> front) {
        Entry entry = this.entries[p];
        ICause cause = entry.c;
        front.put(entry.v, entry.p);
        cause.forEachIntVar(v -> this.findPredecessor(front, (IntVar)v, p));
    }

    @Override
    public void findPredecessor(ValueSortedMap<IntVar> front, IntVar vi, int p) {
        int cpos = front.getValueOrDefault(vi, Integer.MAX_VALUE);
        if (cpos < Integer.MAX_VALUE) {
            while (cpos > p) {
                cpos = this.entries[cpos].p;
            }
            front.replace(vi, cpos);
        } else {
            front.put(vi, this.rightmostNode(p, vi));
        }
    }

    @Override
    public ICause getCauseAt(int idx) {
        return this.entries[idx].c;
    }

    @Override
    public int getEventMaskAt(int idx) {
        return this.entries[idx].m;
    }

    @Override
    public IntVar getIntVarAt(int idx) {
        return this.entries[idx].v;
    }

    @Override
    public int getValueAt(int idx) {
        return this.entries[idx].e;
    }

    @Override
    public int getDecisionLevelAt(int idx) {
        return this.entries[idx].dl;
    }

    @Override
    public IntIterableRangeSet getDomainAt(int idx) {
        return this.entries[idx].d;
    }

    @Override
    public int getPredecessorOf(int idx) {
        return this.entries[idx].p;
    }

    @Override
    public IntIterableRangeSet getRootDomain(IntVar var) {
        return this.rootEntries.get((Object)var).d;
    }

    @Override
    public void copyComplementSet(IntVar var, IntIterableRangeSet set, IntIterableRangeSet dest) {
        dest.copyFrom(this.rootEntries.get((Object)var).d);
        dest.removeAll(set);
    }

    static class Entry
    implements Comparator<Entry> {
        IntVar v;
        IntIterableRangeSet d = new IntIterableRangeSet();
        ICause c;
        int m;
        int e;
        int i;
        int p;
        int dl;

        public String toString() {
            return String.format("<%s, %s, %s, %s, %d, %d, %d>", this.v.getName(), this.d, this.c, this.m, this.i, this.p, this.dl);
        }

        Entry() {
        }

        public void set(IntVar v, ICause c, int m, int e, int i, int p, int dl) {
            this.v = v;
            this.c = c;
            this.m = m;
            this.e = e;
            this.i = i;
            this.p = p;
            this.dl = dl;
        }

        public IntIterableRangeSet getD() {
            return this.d;
        }

        void setPrev(int p) {
            this.p = p;
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.i - o2.i;
        }
    }
}

