% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/name_usage.r
\name{name_usage}
\alias{name_usage}
\title{Lookup details for specific names in all taxonomies in GBIF.}
\usage{
name_usage(key = NULL, name = NULL, data = "all", language = NULL,
  datasetKey = NULL, uuid = NULL, sourceId = NULL, rank = NULL,
  shortname = NULL, start = NULL, limit = 100, return = "all", ...)
}
\arguments{
\item{key}{(numeric) A GBIF key for a taxon}

\item{name}{(character) Filters by a case insensitive, canonical namestring,
e.g. 'Puma concolor'}

\item{data}{(character) Specify an option to select what data is returned. See Description
below.}

\item{language}{(character) Language, default is english}

\item{datasetKey}{(character) Filters by the dataset's key (a uuid)}

\item{uuid}{(character) A uuid for a dataset. Should give exact same results as datasetKey.}

\item{sourceId}{(numeric) Filters by the source identifier. Not used right now.}

\item{rank}{(character) Taxonomic rank. Filters by taxonomic rank as one of:
  CLASS, CULTIVAR, CULTIVAR_GROUP, DOMAIN, FAMILY, FORM, GENUS, INFORMAL,
  INFRAGENERIC_NAME, INFRAORDER, INFRASPECIFIC_NAME, INFRASUBSPECIFIC_NAME,
KINGDOM, ORDER, PHYLUM, SECTION, SERIES, SPECIES, STRAIN, SUBCLASS, SUBFAMILY,
SUBFORM, SUBGENUS, SUBKINGDOM, SUBORDER, SUBPHYLUM, SUBSECTION, SUBSERIES,
SUBSPECIES, SUBTRIBE, SUBVARIETY, SUPERCLASS, SUPERFAMILY, SUPERORDER,
SUPERPHYLUM, SUPRAGENERIC_NAME, TRIBE, UNRANKED, VARIETY}

\item{shortname}{(character) A short name..need more info on this?}

\item{start}{Record number to start at. Default: 0. Use in combination with \code{limit} to
page through results.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{return}{One of data, meta, or all. If data, a data.frame with the
data. meta returns the metadata for the entire call. all gives all data back in a list.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\value{
A list of length two. The first element is metadata. The second is
a data.frame
}
\description{
Lookup details for specific names in all taxonomies in GBIF.
}
\details{
This service uses fuzzy lookup so that you can put in partial names and
you should get back those things that match. See examples below.

This function is different from \code{name_lookup} in that that function
searches for names. This function encompasses a bunch of API endpoints,
most of which require that you already have a taxon key, but there is one
endpoint that allows name searches (see examples below).

Note that \code{data="verbatim"} hasn't been working.

Options for the data parameter are: 'all', 'verbatim', 'name', 'parents', 'children',
'related', 'synonyms', 'descriptions','distributions', 'media',
'references', 'speciesProfiles', 'vernacularNames', 'typeSpecimens', 'root'

This function used to be vectorized with respect to the \code{data} parameter,
where you could pass in multiple values and the function internally loops
over each option making separate requests. This has been removed. You can still
loop over many options for the \code{data} parameter, just use an \code{lapply}
family function, or a for loop, etc.
}
\examples{
\dontrun{
# A single name usage
name_usage(key=1)

# Name usage for a taxonomic name
name_usage(name='Puma', rank="GENUS")

# All name usages
name_usage()

# References for a name usage
name_usage(key=2435099, data='references')

# Species profiles, descriptions
name_usage(key=3119195, data='speciesProfiles')
name_usage(key=3119195, data='descriptions')
name_usage(key=2435099, data='children')

# Vernacular names for a name usage
name_usage(key=3119195, data='vernacularNames')

# Limit number of results returned
name_usage(key=3119195, data='vernacularNames', limit=3)

# Search for names by dataset with datasetKey parameter
name_usage(datasetKey="d7dddbf4-2cf0-4f39-9b2a-bb099caae36c")

# Search for a particular language
name_usage(key=3119195, language="FRENCH", data='vernacularNames')

# Pass on httr options
## here, print progress, notice the progress bar
library('httr')
# res <- name_usage(name='Puma concolor', limit=300, config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/species#nameUsages}
}

