% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_usage.r
\name{name_usage}
\alias{name_usage}
\title{Lookup details for specific names in all taxonomies in GBIF.}
\usage{
name_usage(
  key = NULL,
  name = NULL,
  data = "all",
  language = NULL,
  datasetKey = NULL,
  uuid = NULL,
  rank = NULL,
  shortname = NULL,
  start = 0,
  limit = 100,
  return = NULL,
  curlopts = list(http_version = 2)
)
}
\arguments{
\item{key}{(numeric or character) A GBIF key for a taxon}

\item{name}{(character) Filters by a case insensitive, canonical namestring,
e.g. 'Puma concolor'}

\item{data}{(character) Specify an option to select what data is returned.
See Description below.}

\item{language}{(character) Language, default is english}

\item{datasetKey}{(character) Filters by the dataset's key (a uuid). Must
be length=1}

\item{uuid}{(character) A dataset key}

\item{rank}{(character) Taxonomic rank. Filters by taxonomic rank as
one of: CLASS, CULTIVAR, CULTIVAR_GROUP, DOMAIN, FAMILY, FORM, GENUS,
INFORMAL, INFRAGENERIC_NAME, INFRAORDER, INFRASPECIFIC_NAME,
INFRASUBSPECIFIC_NAME, KINGDOM, ORDER, PHYLUM, SECTION, SERIES, SPECIES,
STRAIN, SUBCLASS, SUBFAMILY, SUBFORM, SUBGENUS, SUBKINGDOM, SUBORDER,
SUBPHYLUM, SUBSECTION, SUBSERIES, SUBSPECIES, SUBTRIBE, SUBVARIETY,
SUPERCLASS, SUPERFAMILY, SUPERORDER, SUPERPHYLUM, SUPRAGENERIC_NAME,
TRIBE, UNRANKED, VARIETY}

\item{shortname}{(character) A short name for a dataset - it may
not do anything}

\item{start}{Record number to start at. Default: 0.}

\item{limit}{Number of records to return. Default: 100.}

\item{return}{Defunct. All components are returned; index to the
one(s) you want}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
An object of class gbif, which is a S3 class list, with slots for
metadata (\code{meta}) and the data itself (\code{data}). In addition, the
object has attributes listing the user supplied arguments and type of
search, which is, differently from occurrence data, always equals to
'single' even if multiple values for some parameters are given. \code{meta}
is a list of length four with offset, limit, endOfRecords and count fields.
\code{data} is a tibble (aka data.frame) containing all information about
the found taxa.
}
\description{
Lookup details for specific names in all taxonomies in GBIF.
}
\details{
This service uses fuzzy lookup so that you can put in partial names and
you should get back those things that match. See examples below.

This function is different from \code{\link[=name_lookup]{name_lookup()}} in that that function
searches for names. This function encompasses a bunch of API endpoints,
most of which require that you already have a taxon key, but there is one
endpoint that allows name searches (see examples below).

Note that \code{data="verbatim"} hasn't been working.

Options for the data parameter are: 'all', 'verbatim', 'name', 'parents',
'children', 'related', 'synonyms', 'descriptions','distributions', 'media',
'references', 'speciesProfiles', 'vernacularNames', 'typeSpecimens', 'root',
'iucnRedListCategory'

This function used to be vectorized with respect to the \code{data}
parameter, where you could pass in multiple values and the function
internally loops over each option making separate requests. This has been
removed. You can still loop over many options for the \code{data} parameter,
just use an \code{lapply} family function, or a for loop, etc.

See \code{\link[=name_issues]{name_issues()}} for more information about issues in \code{issues} column.
}
\section{Repeat parameter inputs}{

These parameters used to accept many inputs, but no longer do:

\itemize{
\item \strong{rank}
\item \strong{name}
\item \strong{langugae}
\item \strong{datasetKey}
}
}

\examples{
\dontrun{
# A single name usage
name_usage(key=1)

# Name usage for a taxonomic name
name_usage(name='Puma', rank="GENUS")

# Name usage for all taxa in a dataset
# (set sufficient high limit, but less than 100000)
# name_usage(datasetKey = "9ff7d317-609b-4c08-bd86-3bc404b77c42", 
#  limit = 10000)
# All name usages
name_usage()

# References for a name usage
name_usage(key=2435099, data='references')

# Species profiles, descriptions
name_usage(key=3119195, data='speciesProfiles')
name_usage(key=3119195, data='descriptions')
name_usage(key=2435099, data='children')

# Vernacular names for a name usage
name_usage(key=3119195, data='vernacularNames')

# Limit number of results returned
name_usage(key=3119195, data='vernacularNames', limit=3)

# Search for names by dataset with datasetKey parameter
name_usage(datasetKey="d7dddbf4-2cf0-4f39-9b2a-bb099caae36c")

# Search for a particular language
name_usage(key=3119195, language="FRENCH", data='vernacularNames')

# get root usage with a uuid
name_usage(data = "root", uuid = "73605f3a-af85-4ade-bbc5-522bfb90d847")

# search by language
name_usage(language = "spanish")

# Pass on curl options
name_usage(name='Puma concolor', limit=300, curlopts = list(verbose=TRUE))

# look up iucn red list category 
name_usage(key = 7707728, data = 'iucnRedListCategory') 
}
}
\references{
\url{https://www.gbif.org/developer/species#nameUsages}
}
