% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-upload.R
\name{ee_utils_create_manifest_table}
\alias{ee_utils_create_manifest_table}
\title{Create a manifest to upload a table}
\usage{
ee_utils_create_manifest_table(
  gs_uri,
  assetId,
  start_time = "1970-01-01",
  end_time = "1970-01-01",
  properties = NULL,
  returnList = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{gs_uri}{Character. GCS full path of the table to upload to Earth Engine assets
e.g. gs://rgee_dev/nc.zip}

\item{assetId}{Character. How to call the file once uploaded
to the Earth Engine Asset. e.g. users/datacolecfbf/nc.}

\item{start_time}{Character. Sets the start time property (system:time_start).
It could be a number (timestamp) or a date.}

\item{end_time}{Character. Sets the end time property (system:time_end).
It could be a number (timestamp) or a date.}

\item{properties}{List. Set of parameters to be set up as properties
of the EE object.}

\item{returnList}{Logical. If TRUE will return the "manifest" as a list otherwise
will return a JSON file.}

\item{quiet}{Logical. Suppress info message.}
}
\value{
If \code{returnList} is TRUE, a list otherwise a JSON file.
}
\description{
Create a manifest to upload a zipped shapefile to Earth Engine assets folder. The
"manifest" is simply a JSON file that describe all the upload parameters. See
\url{https://developers.google.com/earth-engine/guides/image_manifest} to get more
details.
}
\examples{
\dontrun{
library(rgee)
library(sf)
ee_Initialize(gcs = TRUE)

x <- st_read(system.file("shape/nc.shp", package = "sf"))
shp_dir <- sprintf("\%s.shp", tempfile())
geozip_dir <- ee_utils_shp_to_zip(x, shp_dir)

# Return a JSON file
manifest <- ee_utils_create_manifest_table(
  gs_uri = "gs://rgee_dev/nc.zip",
  assetId = "users/datacolecfbf/nc"
)

# Return a list
ee_utils_create_manifest_table(
  gs_uri = "gs://rgee_dev/nc.zip",
  assetId = "users/datacolecfbf/nc",
  returnList = TRUE
)
}
}
\seealso{
Other generic upload functions: 
\code{\link{ee_utils_create_manifest_image}()},
\code{\link{local_to_gcs}()}
}
\concept{generic upload functions}
