% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regions.R
\name{gd_bbox}
\alias{gd_bbox}
\title{Prepare Bounding Box Region from X/Y Limits}
\usage{
gd_bbox(...)
}
\arguments{
\item{...}{Either a single terra \code{SpatExtent} object or arguments: \code{xmin}/\code{ymax}/\code{xmax}/\code{ymin}. If the four bounding arguments are not named they should be in order.}
}
\value{
a \emph{list} object describing a GeoJSON bounding rectangular polygon suitable for use as \code{regions} argument to \code{gd_download()} or \code{gd_search()}
}
\description{
Create a bounding box polygon Python object for use with \code{gd_download()}. The coordinates of the bounding box are expressed in WGS84 decimal degrees (\code{"OGC:CRS84"}).
}
\details{
Expecting total of 4 bounding box arguments, If arguments are unnamed they should be in the following order: "xmin", "ymax", "xmax", "ymin".
}
\examples{
gd_bbox(
  xmin = 5.744140,
  ymax = 50.18162,
  xmax = 6.528252,
  ymin = 49.44781
)
}
