% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{variance_components_plot}
\alias{variance_components_plot}
\title{Plots variance components estimates for all unique alleles.}
\usage{
variance_components_plot(varcomp, split_by_fraction = FALSE)
}
\arguments{
\item{varcomp}{Result from a call to get_variance_components.}

\item{split_by_fraction}{If TRUE, then points are colored by allele fraction.}
}
\value{
Returns a ggplot object.
}
\description{
Plots variance components estimates for all unique alleles.
}
\examples{
\donttest{
# Note: First run deletion_analysis()
# The below isn't run since it can take 10+ seconds to run

# mul1_del_results is a pre-loaded result
vc = get_variance_components(mul1_del_results[[1]], mul1_replicates)
variance_components_plot(vc)
}
}
\seealso{
\code{\link{deletion_analysis}}

\code{\link{get_variance_components}}
}
