% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{knn_weights}
\alias{knn_weights}
\title{K-Nearest Neighbors-based Spatial Weights}
\usage{
knn_weights(
  geoda_obj,
  k,
  power = 1,
  is_inverse = FALSE,
  is_arc = FALSE,
  is_mile = TRUE
)
}
\arguments{
\item{geoda_obj}{An instance of geoda}

\item{k}{a positive integer number for k-nearest neighbors}

\item{power}{(optional) The power (or exponent) of a number says how many times to use the number in a multiplication.}

\item{is_inverse}{(optional) FALSE (default) or TRUE, apply inverse on distance value}

\item{is_arc}{(optional) FALSE (default) or TRUE, compute arc distance between two observations}

\item{is_mile}{(optional) TRUE (default) or FALSE, convert distance unit from mile to km.}
}
\value{
An instance of Weight-class
}
\description{
Create a k-nearest neighbors based spatial weights
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
knn6_w <- knn_weights(guerry, 6)
summary(knn6_w)
}
\keyword{knn}
\keyword{weights}
