% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_multiquantilelisa}
\alias{local_multiquantilelisa}
\title{Multivariate Quantile LISA Statistics}
\usage{
local_multiquantilelisa(
  w,
  quantile_data,
  permutations = 999,
  significance_cutoff = 0.05,
  cpu_threads = 6,
  seed = 123456789
)
}
\arguments{
\item{w}{An instance of Weight object}

\item{quantile_data}{A list of [k, q, data] for more than one variable. Each variable will be set with: k, indicates the number of quantiles; q, indicates which quantile or interval used in local join count statistics; data, is a numeric array of selected variable}

\item{permutations}{The number of permutations for the LISA computation}

\item{significance_cutoff}{A cutoff value for significance p-values to filter not-significant clusters}

\item{cpu_threads}{The number of cpu threads used for parallel LISA computation}

\item{seed}{The seed for random number generator}
}
\value{
An instance of LISA-class
}
\description{
The function to apply multivariate quantile LISA statistics
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prp <- guerry_df['Crm_prp'][,1]
lit <- guerry_df['Litercy'][,1]
quantiles <- list(list(4,1,crm_prp), list(4,1, lit))
lisa <- local_multiquantilelisa(queen_w, quantiles)
clsts <- lisa_clusters(lisa)
clsts
}
