% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{maxp_tabu}
\alias{maxp_tabu}
\title{A tabu-search algorithm to solve the max-p-region problem}
\usage{
maxp_tabu(
  w,
  data,
  bound_vals,
  min_bound,
  tabu_length = 10,
  conv_tabu = 10,
  iterations = 99,
  initial_regions = vector("numeric"),
  distance_method = "euclidean",
  random_seed = 123456789,
  cpu_threads = 6
)
}
\arguments{
\item{w}{An instance of Weight class}

\item{data}{A list of numeric vectors of selected variable}

\item{bound_vals}{A numeric vector of selected bounding variable}

\item{min_bound}{A minimum value that the sum value of bounding variable int each cluster should be greater than}

\item{tabu_length}{(optional): The length of a tabu search heuristic of tabu algorithm. Defaults to 10.}

\item{conv_tabu}{(optional): The number of non-improving moves. Defaults to 10.}

\item{iterations}{(optional): The number of iterations of Tabu algorithm. Defaults to 99.}

\item{initial_regions}{(optional): The initial regions that the local search starts with. Default is empty. means the local search starts with a random process to "grow" clusters}

\item{distance_method}{(optional) The distance method used to compute the distance betwen observation i and j. Defaults to "euclidean". Options are "euclidean" and "manhattan"}

\item{random_seed}{(optional) The seed for random number generator. Defaults to 123456789.}

\item{cpu_threads}{(optional) The number of cpu threads used for parallel computation}
}
\value{
A list of numeric vectors represents a group of clusters
}
\description{
The max-p-region problem is a special case of constrained
clustering where a finite number of geographical areas are aggregated into
the maximum number of regions (max-p-regions), such that each region is
geographically connected and the clusters could maximize internal homogeneity.
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
data <- guerry_df[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
bound_vals <- guerry_df['Pop1831'][,1]
min_bound <- 3236.67 # 10\% of Pop1831
maxp_clusters <- maxp_tabu(queen_w, data, bound_vals, min_bound, tabu_length=10, conv_tabu=10)
maxp_clusters
}
}
