% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/telize.R
\name{telize}
\alias{telize}
\title{Geolocate IP Addresses Through telize.com}
\usage{
telize(ip_addresses, as_data_frame = TRUE)
}
\arguments{
\item{ip_addresses}{a vector of IP addresses.}

\item{as_data_frame}{whether to return the results as a data.frame (TRUE)
or a list of named vectors (FALSE). Set to TRUE by default.}
}
\value{
either a data.frame or a list of named vectors, depending on
the option for \code{as_data_frame}
}
\description{
\href{http://telize.com}{telize.com} provides IP geolocation based
on MaxMind's free downloadable databases (one of which is, distinctly, included in
this package). \code{telize} allows you to query the Telize service to geolocate
IPv4 or IPv6 IP addresses.
}
\examples{
\dontrun{
#Valid, data.frame output
result <- telize("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93")

#Invalid, data.frame output
result <- telize("argh")

#Valid list output
result <- telize("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93", as_data_frame = FALSE)

#Invalid list output
result <- telize("argh", as_data_frame = FALSE)
}
}

