\name{check.dpl.edges}
\alias{check.dpl.edges}
\title{Check (and count) duplicated edges}
\description{Looks for duplicated edges and reports the number of instances of them.}
\usage{
check.dpl.edges(edges, undirected=FALSE, order.edgelist=TRUE)
}
\arguments{
  \item{edges}{A matrix or data frame structured as a list of edges}
  \item{undirected}{Declares if the net is directed or not (does de diference)}
  \item{order.edgelist}{Wether to sort the resulting matrix or not}
}
\details{
  \code{check.dpl.edges} looks for duplicated edges reporting duplicates and counting how many times each edge is duplicated. 
  
  For every group of duplicated edges only one will be accounted to report number of instances (which will be recognized with a value higher than 2 in the \code{reps} column), the other ones will be assigned a \code{-1} at the \code{reps} value.
  
  Function is mainly written in C, so speed gains are important. 
}
\value{
  A three column \code{data.frame} with colnames \dQuote{source}, \dQuote{target} \dQuote{reps}.
}
\author{George Vega Yon \email{george.vega@nodoschile.org}}
\examples{
  # An edgelist with duplicated dyads
  relations <- cbind(c(1,1,3,4,2,5,6), c(2,3,1,2,4,1,1))
  
  # Checking duplicated edges (undirected graph)
  check.dpl.edges(edges=relations, undirected=TRUE)
}
\keyword{ manip }