\name{randexprTypedGrow}
\alias{randexprTypedFull}
\alias{randexprTypedGrow}
\title{Creates an R expression by random growth respecting type constraints}
\usage{
  randexprTypedGrow(type, funcset, inset, conset,
    maxdepth = 8, constprob = 0.2, subtreeprob = 0.5,
    curdepth = 1)

  randexprTypedFull(type, funcset, inset, conset,
    maxdepth = 8, constprob = 0.2)
}
\arguments{
  \item{type}{The (range) type the created expression
  should have.}

  \item{funcset}{The function set.}

  \item{inset}{The set of input variables.}

  \item{conset}{The set of constant factories.}

  \item{maxdepth}{The maximum expression tree depth.}

  \item{constprob}{The probability of generating a constant
  in a step of growth, if no subtree is generated. If
  neither a subtree nor a constant is generated, a randomly
  chosen input variable will be generated. Defaults to
  \code{0.2}.}

  \item{subtreeprob}{The probability of generating a
  subtree in a step of growth.}

  \item{curdepth}{(internal) The depth of the random
  expression currently generated, used internally in
  recursive calls.}
}
\value{
  A new R expression generated by random growth.
}
\description{
  Creates a random R expression by randomly growing its
  tree. In each step of growth, with probability
  \code{subtreeprob}, an operator is chosen from the
  function set \code{funcset}. The operands are then
  generated by recursive calls. If no function of matching
  range type exists, a terminal (constant or input
  variable) will be generated instead. If no subtree is
  generated, a constant will be generated with probability
  \code{constprob}. If no constant is generated, an input
  variable will be chosen randomly. The depth of the
  resulting expression trees can be bounded by the
  \code{maxdepth} parameter. In contrast to
  \code{randexprGrow}, this function respects sTypes of
  functions, input variables, and constant factories. Only
  well-typed expressions are created.
  \code{randexprTypedFull} creates a random full expression
  tree of depth \code{maxdepth}, respecting type
  constraints.
}

