\name{xyplot.eda8}
\alias{xyplot.eda8}
\title{ Display a Third Variable in a X-Y Plot as Percentiles } 
\description{
Displays a third variable on a X-Y plot where the the third variable is represented by symbols indicating within which group defined by the data's 2nd, 5th, 25th, 50th, 75th, 95th and 98th percentiles plotted a data value falls. The colours of the symbols may be optionally changed.  The x-y plot axes may be optionally displayed with logarithmic (base 10) scaling.  Optionally a legend (two options) may be added to the plot.
}
\usage{
xyplot.eda8(xx, yy, zz, sfact = 1, xlim = NULL, ylim = NULL, 
	xlab = deparse(substitute(xx)), ylab = deparse(substitute(yy)), 
	zlab = deparse(substitute(zz)), main = "", log = NULL,
	ifgrey = FALSE, symcolr = NULL, iflgnd = FALSE, pctile = FALSE,
        title = deparse(substitute(zz)), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{xx}{ name of the x-axis variable. }
  \item{yy}{ name of the y-axis variable. }
  \item{zz}{ name of the third variable to be plotted. }
  \item{sfact}{ controls the absolute size of the plotted symbols, by default \code{sfact = 1}.  Increasing \code{sfact} results in larger symbols. }
  \item{log}{ if it is required to display the data with logarithmic axis scaling, set \code{log = "x"} for a logarithmically scaled x-axis, \code{log = "y"} for a logarithmically scaled y-axis, and \code{log = "xy"} for both axes logarithmically scaled. }
  \item{xlim}{ user defined limits for the x-axis, see Details below. }
  \item{ylim}{ user defined limits for the y-axis, see Details below. }
  \item{xlab}{ the x-axis title, by default the variable name, \code{deparse(substitute(xx))}. It is often desirable to replace the default x-axis title of the input variable name text string with a more informative title, e.g., \code{xlab = "Fe (mg/kg) in stream sediment"}. }
  \item{ylab}{ the y-axis title, by default the variable name, \code{deparse(substitute(yy))}. It is often desirable to replace the default y-axis title of the input variable name text string with a more informative title, e.g., \code{ylab = "Mn (mg/kg) in stream sediment"}. }
  \item{zlab}{ by default, \code{zlab = deparse(substitute(zz))}, a plot title is generated by appending the input variable name text string to \code{Proportional Symbol Plot for }. Alternative titles may be generated, see Details below. }
  \item{main}{ an alternative plot title, see Details below.}
  \item{ifgrey}{ set \code{ifgrey = TRUE} if a grey-scale plot is required, see Details below. }
  \item{symcolr}{ the default is a colour plot and default colours are provided, deeper blues for lower values, green for the middle 50\% of the data, and oranges and reds for higher values.  A set of alternate symbol colours can be provided by defining \code{symcolr}, see Details below. }
  \item{iflgnd}{ the default is no legend.  If a legend is required set \code{iflegnd = TRUE}, following the plotting of the data the cursor will be activated, locate that at the top left corner of the desired legend position and \sQuote{left button} on the pointing device.  There are two legends to choose from, see \code{pctile} below. }
  \item{pctile}{ the default legend displays the range of values each symbol represents.  If \code{pctile = TRUE} the range of percentiles will be displayed instead of their actual values. }
  \item{title}{ a short title for the legend, e.g., \code{title = "Zn (mg/kg"}.  The default is the variable name. } 
  \item{\dots}{ further arguments to be passed to methods.  For example, if it is required to make the plot title smaller, add \code{cex.main = 0.9} to reduce the font size by 10\%. }
}
\details{
The selected percentiles, 2nd, 5th, 25th, 50th, 75th, 95th and 98th, divide the data into 8 groups. Values below the median are represented by increasingly larger deeper blue circles below the 25th percentile (Q1), and values above the 75th percentile (Q3) by increasingly larger orange and red squares. The mid 50\% of the data are represented by green symbols, circles for the median (Q2) to Q1, and squares for the median (Q2) to Q3.

A summary table of the values of the symbol intervals, the number of values plotting as each symbol, and symbol shapes, sizes and colours is displayed on the current device.

If \code{zlab} and \code{main} are undefined a default a plot title is generated by appending the input variable name text string to \code{"EDA Percentile Based Plot for "}. If no plot title is required set \code{zlab = " "}, and if some user defined plot title is required it should be defined in \code{main}, e.g. \code{main = "Plot Title Text"}.

If the grey-scale option is chosen the symbols are plotted 100\% black for the far outliers, 85\% black for the near outliers, 70\% black for values within the whiskers, and 60\% black for values falling within the middle 50\% of the data.

The default colours, \code{symcolr = c(25, 22, 20, 13, 13, 6, 4, 1)}, are selected from the \code{rainbow(36)} pallette, and alternate colour schemes need to be selected from the same palette.  See \code{\link{display.rainbow}} for the available colours. It is essential that 8 colours be provided, e.g., \code{symcolr = c(27, 24, 22, 12, 12, 5, 3, 36)}, if exactly 8 are not provided the default colours will be displayed.
}
\note{
Any less than detection limit values represented by negative values, or zeros or other numeric codes representing blanks in the data vector, must be removed prior to executing this function, see \code{\link{ltdl.fix.df}}.

Any data vectors including \code{NA}s are removed prior to displaying the plot.
}
\author{ Robert G. Garrett }
\seealso{  \code{\link{display.rainbow}}, \code{\link{ltdl.fix.df}}, \code{\link{remove.na}} }
\examples{
## Make test data available
data(sind)
attach(sind)

## Plot a default percentile display
xyplot.eda8(Fe, Mn, Zn)

## Plot with more appropriate axis scaling and labelling
## with a user specified title
xyplot.eda8(Fe, Mn, Zn, sfact = 2.0, log = "y",
	xlab = "Fe (pct) in stream sediment",
	ylab = "Mn (mg/kg) in stream sediment",
	main = "Howarth & Sinding-Larsen Test Data\nZn (mg/kg)") 

## Display a grey-scale equivalent of the above plot
xyplot.eda8(Fe, Mn, Zn, sfact = 2, log = "y", ifgrey = TRUE,
	xlab = "Fe (pct) in stream sediment",
	ylab = "Mn (mg/kg) in stream sediment",
	main = "Howarth & Sinding-Larsen Test Data\nZn (mg/kg)") 

## Plot the same display with an alternate colour scheme
xyplot.eda8(Fe, Mn, Zn, sfact = 2, log = "y",
	xlab = "Fe (pct) in stream sediment",
	ylab = "Mn (mg/kg) in stream sediment",
	main = "Howarth & Sinding-Larsen Test Data\nZn (mg/kg)",
	symcolr = c(27, 24, 22, 12, 12, 5, 3, 36)) 

## Detach test data
detach(sind)
}
\keyword{ hplot }

