% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistence_diagram_sample.R
\name{mean.persistence_diagram_sample}
\alias{mean.persistence_diagram_sample}
\title{Persistence Diagram Sample Mean}
\usage{
\method{mean}{persistence_diagram_sample}(x, initial_center = NULL, verbose = FALSE, ...)
}
\arguments{
\item{x}{An object of class \link{persistence_diagram_sample}.}

\item{initial_center}{Either an integer value specifying the index of a
persistence diagram in the input list to be used as initial center or an
object of class \link{persistence_diagram} to be used as initial center.
Defaults to \code{NULL}, which randomly chooses a center from the input list.}

\item{verbose}{A boolean specifying whether information should be displayed
into the console. Defaults to \code{FALSE}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \link{persistence_diagram}.
}
\description{
Currently computes the Fréchet mean associated with the 2-Wasserstein
distance, a.k.a Wasserstein barycenter.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi") && requireNamespace("tibble", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dg1 <- as_persistence_diagram(tibble::tibble(birth = 0.2, death = 0.5))
dg2 <- as_persistence_diagram(tibble::tibble(birth = 0.2, death = 0.7))
dg3 <- as_persistence_diagram(tibble::tibble(
  birth = c(0.3, 0.7, 0.2),
  death = c(0.6, 0.8, 0.3)
))
pdset <- as_persistence_diagram_sample(list(dg1, dg2, dg3))
bary <- mean(pdset)
\dontshow{\}) # examplesIf}
}
