% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sub_cluster.R
\name{plot_sub_cluster}
\alias{plot_sub_cluster}
\title{plot_sub_cluster}
\usage{
plot_sub_cluster(hb.object, tree, level, sub.cluster)
}
\arguments{
\item{hb.object}{The resulting object from running hierBAPS}

\item{tree}{A phylo tree object to plot}

\item{level}{The level of the subcluster to be considered.}

\item{sub.cluster}{An integer representing the subcluster to be considered.}
}
\description{
Creates a zoom plot using ggtree focusing on a cluster.
}
\examples{
\donttest{
snp.matrix <- load_fasta(system.file("extdata", "seqs.fa", package = "rhierbaps"))
newick.file.name <- system.file("extdata", "seqs.fa.treefile", package = "rhierbaps")
tree <- phytools::read.newick(newick.file.name)
hb.result <- hierBAPS(snp.matrix, max.depth=2, n.pops=20)
plot_sub_cluster(hb.result, tree, level = 1, sub.cluster = 9)
}
}
