# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title sample_contingency_table
#' @name sample_contingency_table
#' 
#' @param xx contingency table matrix
#' @param n int size of the contingency table
#' @param forR bool if true, add 1 to the results accounting for R indices starting at 1
#' 
#' @export
sample_contingency_table <- function(xx, n, forR = TRUE) {
    .Call('_rhoR_sample_contingency_table', PACKAGE = 'rhoR', xx, n, forR)
}

#' @name getBootPvalue_c
#' @title getBootPvalue_c
#' 
#' @param distribution vector of calculated kappas
#' @param result double calculated kappa to compare against
#' 
#' @description 
#' returns the percentage of the time that the distribution was greater or equal to the observed kappa
#' if the result is less than the mean of the distribution, than the p value is 1
#' else return the number of times that the distribution is greater than the result as a percentage of the total number 
#' of items in the distribution
#'
#' @return double calculated p-value
#'
#' @export
getBootPvalue_c <- function(distribution, result) {
    .Call('_rhoR_getBootPvalue_c', PACKAGE = 'rhoR', distribution, result)
}

check_BRK_combo <- function(BR, P, K) {
    .Call('_rhoR_check_BRK_combo', PACKAGE = 'rhoR', BR, P, K)
}

#' @name recall
#' @title recall
#' 
#' @param kappa double
#' @param BR double
#' @param P double
#' 
#' @return Recall calculated from provided kappa, BR, and P
#' 
#' @export
recall <- function(kappa, BR, P) {
    .Call('_rhoR_recall', PACKAGE = 'rhoR', kappa, BR, P)
}

find_valid_pk <- function(kappaDistribution, kappaProbability, precisionDistribution, precisionProbability, baserate) {
    .Call('_rhoR_find_valid_pk', PACKAGE = 'rhoR', kappaDistribution, kappaProbability, precisionDistribution, precisionProbability, baserate)
}

#' @name generateKPs_c
#' @title generate_kp_list
#' 
#' @param numNeeded int
#' @param baserate double
#' @param kappaMin double
#' @param kappaMax double
#' @param precisionMin double
#' @param precisionMax double
#' @param distributionType int 0 - normal (default), 1 - bell
#' @param distributionLength long
#' 
#' @return matrix of kappa and precision values (column 1 as precision)
#' 
#' @export
generate_kp_list <- function(numNeeded, baserate, kappaMin, kappaMax, precisionMin, precisionMax, distributionType = 0L, distributionLength = 10000L) {
    .Call('_rhoR_generate_kp_list', PACKAGE = 'rhoR', numNeeded, baserate, kappaMin, kappaMax, precisionMin, precisionMax, distributionType, distributionLength)
}

#' @name contingency_table
#' @title contingency_table
#' @description Create a contingency table using the provied precision, recall, baserate, and length.
#' 
#' @param precision double
#' @param rec double
#' @param length int
#' @param baserate double
#' 
#' @export
contingency_table <- function(precision, rec, length, baserate) {
    .Call('_rhoR_contingency_table', PACKAGE = 'rhoR', precision, rec, length, baserate)
}

#' @name random_contingency_table
#' @title random_contingency_table
#' @param setLength [TBD]
#' @param baserate [TBD]
#' @param kappaMin [TBD]
#' @param kappaMax [TBD]
#' @param minPrecision [TBD]
#' @param maxPrecision [TBD]
#' 
#' @export
random_contingency_table <- function(setLength, baserate, kappaMin, kappaMax, minPrecision = 0, maxPrecision = 1) {
    .Call('_rhoR_random_contingency_table', PACKAGE = 'rhoR', setLength, baserate, kappaMin, kappaMax, minPrecision, maxPrecision)
}

#' @title kappa_ct
#' @description Calculate kappa from a contingency table
#' @param ct [TBD]
#' 
#' @export
kappa_ct <- function(ct) {
    .Call('_rhoR_kappa_ct', PACKAGE = 'rhoR', ct)
}

getHand_ct <- function(ct, handSetLength, handSetBaserate) {
    .Call('_rhoR_getHand_ct', PACKAGE = 'rhoR', ct, handSetLength, handSetBaserate)
}

#' @name getHand_kappa
#' @title getHand_kappa
#' 
#' @description This function returns kappa calculated from a Handset taken from  a larger Contingency Table
#' 
#' @param ct KPs matrix of kappa (column 1) and precision (column 2) values
#' @param handSetLength The length of the \code{\link[=getTestSet]{testSet}} (ignored unless \emph{data} is an observed kappa value)
#' @param handSetBaserate baserate to inflate the sampled contingency table to
#' 
#' @return Kappa as double
#' 
#' @export
getHand_kappa <- function(ct, handSetLength, handSetBaserate) {
    .Call('_rhoR_getHand_kappa', PACKAGE = 'rhoR', ct, handSetLength, handSetBaserate)
}

calcRho_c <- function(x, OcSBaserate, testSetLength, testSetBaserateInflation = 0, OcSLength = 10000L, replicates = 800L, ScSKappaThreshold = 0.9, ScSKappaMin = 0.40, ScSPrecisionMin = 0.6, ScSPrecisionMax = 1.0, KPs = matrix(0)) {
    .Call('_rhoR_calcRho_c', PACKAGE = 'rhoR', x, OcSBaserate, testSetLength, testSetBaserateInflation, OcSLength, replicates, ScSKappaThreshold, ScSKappaMin, ScSPrecisionMin, ScSPrecisionMax, KPs)
}

