% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Intree.R
\name{intree}
\alias{intree}
\title{Interpreting Tree Ensembles with inTrees}
\usage{
intree(X, Y, ntree, typeDecay = 2, digits, n_rule)
}
\arguments{
\item{X}{A matrix indicating the predictor variables.}

\item{Y}{A response vector. If a factor, classification is assumed, otherwise regression is assumed.}

\item{ntree}{Number of trees to grow. This should not be set to too small a number, to ensure that every input row gets predicted at least a few times.}

\item{typeDecay}{An integer of 1 or 2. 1 representing relative error and 2 representing error. The default is set to 2.}

\item{digits}{An integer indicating the digits for rounding in Intrees.}

\item{n_rule}{An integer indicating the minimum number of rules to consider in Intrees.}
}
\value{
A matrix including a set of relevant and non-redundant rules, and their metrics
}
\description{
The inTrees (interpretable trees) framework that extracts, measures, prunes and selects rules from a tree ensemble. All the codes we use are from the inTrees github repository to act as a work around method since package inTrees was removed from the CRAN repository.
}
\examples{

X <- within(iris,rm("Species")); Y <- iris[,"Species"]
intree_result <- intree(X, Y, ntree=100, digits = 3, n_rule = 2000)


}
