% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{point.estimates}
\alias{point.estimates}
\title{Calculate a point estimate}
\usage{
point.estimates(
  calib,
  wmean = TRUE,
  median = TRUE,
  mode = TRUE,
  midpoint = TRUE,
  prob = 0.95,
  rounded = 1,
  every = 1
)
}
\arguments{
\item{calib}{The calibrated distribution, as returned from caldist()}

\item{wmean}{Report the weighted mean (defaults to TRUE)}

\item{median}{Report the median (defaults to TRUE)}

\item{mode}{Report the mode, which is the year with the maximum probability (defaults to TRUE)}

\item{midpoint}{Report the midpoint of the hpd range(s)}

\item{prob}{probability range for the hpd range(s)}

\item{rounded}{Rounding for reported probabilities. Defaults to 1 decimal.}

\item{every}{Yearly precision (defaults to \code{every=1}).}
}
\value{
The chosen point estimates
}
\description{
Calculate a point estimate of a calibrated distribution - either the weighted mean, the median or the mode (maximum). Note that point estimates often tend to be very poor representations of entire calibrated distributions, so please be careful and do not reduce entire calibrated distributions to just 1 point value.
}
\examples{
point.estimates(caldist(130,20))
plot(tmp <- caldist(2450,50), type='l')
abline(v=point.estimates(tmp), col=1:4)
}
