\name{coef.ridgeLinear}
\alias{coef.ridgeLinear}

\title{
  Extract the coefficients from a linear ridge regression fit computed
  by a call to \code{linearRidge}.
}
\description{
  Extract the coefficients from a linear ridge regression fit computed
  by a call to \code{linearRidge}.
  Where the ridge parameter was chosen automatically (using \code{lambda
  = "automatic"}), optionally print the coefficients corresponding to
  the ridge parameter computed using all numbers of principal components.
}
\usage{
\method{coef}{ridgeLinear}(object, all.coef = FALSE, ...)
}

\arguments{
  \item{object}{
    A \code{ridgeLinear} object, typically generated by a call to \code{linearRidge}.
}
  \item{all.coef}{
    Logical. If \code{lambda = "automatic"}, should results be returned
      for all ridge regression penalty paramters?
}
  \item{\dots}{
    Additional arguments to be passed to or from other methods. 
}
}
\details{
  If \code{linearRidge} was called with \code{lambda = "automatic"}
  then \code{coef.ridgeLinear} will only print the regression
  coefficients fitted using the automatically chosen ridge parameter To
  print the regression coefficients for all values of the shrinkage
  parameter, use \code{all.coef = TRUE}.
  Otherwise, all the coefficients are printed.
}
\value{
A numeric vector or matrix of ridge regression coefficients.
}
\references{
  A semi-automatic method to guide the choice of ridge parameter in ridge
  regression. Cule, E. and De Iorio, M. (2012) arXiv:1205.0686v1
}
\author{
  Erika Cule
}
\seealso{
\code{\link{linearRidge}}
}
\examples{
data(GenCont)
mod <- linearRidge(Phenotypes ~ ., data = as.data.frame(GenCont))
coef(mod)
coef(mod, all.coef = TRUE)
}

