% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idig_search_media.R
\name{idig_search_media}
\alias{idig_search_media}
\title{Searching of iDigBio media records}
\usage{
idig_search_media(
  mq = FALSE,
  rq = FALSE,
  fields = FALSE,
  max_items = 1e+05,
  limit = 0,
  offset = 0,
  sort = FALSE,
  ...
)
}
\arguments{
\item{mq}{iDigBio media query in nested list format}

\item{rq}{iDigBio record query in nested list format}

\item{fields}{vector of fields that will be contained in the data.frame,
defaults to "all" which is all indexed fields}

\item{max_items}{maximum number of results allowed to be retrieved (fail
-safe)}

\item{limit}{maximum number of results returned}

\item{offset}{number of results to skip before returning results}

\item{sort}{vector of fields to use for sorting, UUID is always appended to
make paging safe}

\item{...}{additional parameters}
}
\value{
A data frame with fields requested or the following default fields:
\itemize{
\item{\href{https://ac.tdwg.org/termlist/#ac_accessURI}{accessuri} }
\item{datemodified: Date last modified, which is assigned by iDigBio.}
\item{dqs: Data quality score assigned by iDigBio.}
\item{etag: Tag assigned by iDigBio.}
\item{flags: Data quality flag assigned by iDigBio.}
\item{\href{https://purl.org/dc/terms/format}{format} }
\item{hasSpecimen: TRUE or FALSE, indicates if there is an associated record for this media.}
\item{\href{https://ac.tdwg.org/termlist/#ac_licenseLogoURL}{licenselogourl}}
\item{mediatype: Media object type.}
\item{\href{https://purl.org/dc/terms/modified}{modified}}
\item{recordids: List of UUID for associated records.}
\item{records: UUID for the associated record.}
\item{recordset: Record set ID assigned by iDigBio.}
\item{\href{https://purl.org/dc/terms/rights}{rights}}
\item{\href{https://rs.tdwg.org/ac/terms/tag}{tag}}
\item{\href{https://purl.org/dc/terms/type}{type}}
\item{uuid: Unique identifier assigned by iDigBio.}
\item{version: Media record version assigned by iDigBio.}
\item{\href{https://developer.adobe.com/xmp/docs/XMPNamespaces/xmpRights/}{webstatement}}
\item{xpixels: As defined by EXIF, x dimension in pixel.}
\item{ypixels: As defined by EXIF,y dimension in pixels.}
}
}
\description{
Function to query the iDigBio API for media records
}
\details{
Also see \code{\link{idig_search_records}} for the full examples of all the
parameters related to searching iDigBio.

Wraps \code{\link{idig_search}} to provide defaults specific to searching
media records. Using this function instead of \code{\link{idig_search}}
directly is recommened. Record queries and media queries objects are allowed
(rq and mq parameters) and media records returned will match the
requirements of both.

This function defaults to returning all indexed media record fields.
}
\examples{
\dontrun{
# Searching for media using a query on related specimen information - first
# 10 media records with image URIs related to a specimen in the genus Acer:
df <- idig_search_media(rq=list(genus="acer"),
                        mq=list("data.ac:accessURI"=list("type"="exists")),
                        fields=c("uuid","data.ac:accessURI"), limit=10)
}
}
\author{
Matthew Collins
}
