% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{riem_measures}
\alias{riem_measures}
\title{Function for getting weather data from one station}
\usage{
riem_measures(station = "VOHY", date_start = "2014-01-01",
  date_end = as.character(Sys.Date()))
}
\arguments{
\item{station}{station ID, see riem_stations()}

\item{date_start}{date of start of the desired data, e.g. "2000-01-01"}

\item{date_end}{date of end of the desired data, e.g. "2016-04-22"}
}
\value{
a data.frame (tibble tibble) with measures, the number of columns can vary from station to station,
but possible variables are
\itemize{
\item station: three or four character site identifier
\item valid: timestamp of the observation (UTC)
\item tmpf: Air Temperature in Fahrenheit, typically @ 2 meters
\item dwpf: Dew Point Temperature in Fahrenheit, typically @ 2 meters
\item relh: Relative Humidity in %
\item drct: Wind Direction in degrees from north
\item sknt: Wind Speed in knots
\item p01i: One hour precipitation for the period from the observation time to the time of the previous hourly precipitation reset. This varies slightly by site. Values are in inches. This value may or may not contain frozen precipitation melted by some device on the sensor or estimated by some other means. Unfortunately, we do not know of an authoritative database denoting which station has which sensor.
\item alti: Pressure altimeter in inches
\item mslp: Sea Level Pressure in millibar
\item vsby: Visibility in miles
\item gust: Wind Gust in knots
\item skyc1: Sky Level 1 Coverage
\item skyc2: Sky Level 2 Coverage
\item skyc3: Sky Level 3 Coverage
\item skyc4: Sky Level 4 Coverage
\item skyl1: Sky Level 1 Altitude in feet
\item skyl2: Sky Level 2 Altitude in feet
\item skyl3: Sky Level 3 Altitude in feet
\item skyl4: Sky Level 4 Altitude in feet
\item presentwx: Present Weather Codes (space seperated),
 see e.g. [this manual](http://www.ofcm.gov/fmh-1/pdf/H-CH8.pdf) for further explanations.
\item metar: unprocessed reported observation in METAR format
}
}
\description{
Function for getting weather data from one station
}
\details{
The data is queried through \url{https://mesonet.agron.iastate.edu/request/download.phtml}.
}
\examples{
\dontrun{
riem_measures(station = "VOHY", date_start = "2000-01-01", date_end = "2016-04-22")
}
}

