% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundamentals-statements.R
\name{riingo_fundamentals_statements}
\alias{riingo_fundamentals_statements}
\title{Fundamentals - Statements}
\usage{
riingo_fundamentals_statements(
  ticker,
  start_date = NULL,
  end_date = NULL,
  as_reported = FALSE
)
}
\arguments{
\item{ticker}{One or more tickers to download financial statements for.}

\item{start_date}{The first date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable. The default is to
download 1 year's worth of data.}

\item{end_date}{The last date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable.}

\item{as_reported}{A single logical.

When \code{FALSE}, the most recent data will be returned, including any
revisions for the reporting period. The dates will correspond to the
fiscal end of the quarter or year (note that this can vary from company
to company).

When \code{TRUE}, the endpoint will return the data as it was reported on the
release date. Similarly, the date will correspond to the date the filings
were posted on the SEC website.}
}
\value{
A data frame containing the financial statement information for the
requested tickers.
}
\description{
This function collects financial statement information for individual
tickers. Cash flow, income statement, and balance sheet information are
returned at the quarterly level, with an additional annual report attached
if available.

In the returned data frame, \code{quarter == 0} represents an annual report for
the corresponding \code{year}.

If \code{as_reported = FALSE}, an \code{overview} list column is also returned that
contains a combination of metrics from various statements.

The returned data frame is in a very compact form containing \emph{list columns}.
Each list column is made up of more data frames, where each data frame
represents that particular financial statement for that quarter. The
easiest way to get at the underlying data is to unnest the list columns
individually using \code{tidyr::unnest()}.
}
\examples{
\dontrun{
riingo_fundamentals_statements(c("AAPL", "MSFT"))

riingo_fundamentals_statements(c("AAPL", "MSFT"), as_reported = TRUE)
}
}
\seealso{
Other fundamentals: 
\code{\link{riingo_fundamentals_definitions}()},
\code{\link{riingo_fundamentals_meta}()},
\code{\link{riingo_fundamentals_metrics}()}
}
\concept{fundamentals}
