################################################################################
# Copyright 2017-2018 Gabriele Valentini, Douglas G. Moore. All rights reserved.
# Use of this source code is governed by a MIT license that can be found in the
# LICENSE file.
################################################################################

#' rinform: An R wrapper of the Inform C library. 
#'
#' As for the Inform library, rinform is structured around the concepts of:
#' * discrete empirical probability distributions which form the basis for
#'   all of the information-theoretic measures,
#' * classic information-theoretic measures built upon empirical distributions,
#' * measures of information dynamics for time series.
#'
#' In addition to the core components, rinform also provides a small collection
#' of utilities to deal with time series.
#' 
#' If you are using rinform, consider citing the following articles:
#' 
#' * D.G. Moore, G. Valentini, S.I. Walker, M. Levin. “Inform: Efficient
#'   Information-Theoretic Analysis of Collective Behaviors”. _Frontiers in
#'   Robotics & AI. (under review)
#' * D.G. Moore, G. Valentini, S.I. Walker, M. Levin. “Inform: A Toolkit
#'   for Information-Theoretic Analysis of Complex Systems”. In: Proceedings
#'   of the 2017 IEEE Symposium Series on Computational Intelligence,
#'   Symposium on Artificial Life, IEEE Press, 2017. (in press)
#'
#' @docType package
#' @name rinform
NULL