% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introjs.R
\name{readCallback}
\alias{readCallback}
\title{Read a JS callback function into rintrojs}
\usage{
readCallback(funname = c("switchTabs"))
}
\arguments{
\item{funname}{The name of the function you want to use. Options include:
\describe{
\item{switchTabs}{This function is intended to be passed to IntroJs's
\href{https://introjs.com/docs/intro/api/#introjsonbeforechangeprovidedcallback}{onbeforechange method}. It will switch the currently active tab in your
Shiny app to be the one containing the next element in your tour (this
function is called by IntroJs right before it moves to the next element).
Try running \code{shiny::runApp(system.file("examples/switchTabs.R",
  package = "rintrojs"))} to see an example.
}
}}
}
\value{
A string containing the body of a callback function
}
\description{
Reads a JS callback function into rintrojs
}
\examples{
\dontrun{
introjs(session, events = list(onbeforechange = readCallback("switchTabs")))
}
}
