% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHom.R
\name{tail.PHom}
\alias{tail.PHom}
\title{Last Part of PHom Object}
\usage{
\method{tail}{PHom}(x, ...)
}
\arguments{
\item{x}{object of class \code{PHom}}

\item{...}{other parameters}
}
\description{
Returns the last part of a \code{PHom} instance.
}
\examples{
# create sample persistence data
df <- data.frame(dimension = c(0, 0, 1, 1, 1, 2),
                 birth = rnorm(6),
                 death = rnorm(6, mean = 15))
df_phom <- as.PHom(df)

# look at first 3 features
head(df_phom)

# look at last 3 features
tail(df_phom)
}
