% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admin.R
\name{iadmin}
\alias{iadmin}
\title{The Administration Interface to iRODS}
\usage{
iadmin(
  action,
  target,
  arg2 = character(1),
  arg3 = character(1),
  arg4 = character(1),
  arg5 = character(1),
  arg6 = character(1),
  arg7 = character(1),
  verbose = FALSE
)
}
\arguments{
\item{action}{The action: add, modify, or remove.}

\item{target}{The subject of the action: user, zone, resource, childtoresc,}

\item{arg2}{arg2}

\item{arg3}{arg3}

\item{arg4}{arg4}

\item{arg5}{arg5}

\item{arg6}{arg6}

\item{arg7}{arg7}

\item{verbose}{Show information about the http request and response.
Defaults to \code{FALSE}.}
}
\value{
Invisible http status.
}
\description{
Note that this function can only be used with admin rights.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authentication
iauth("rods", "rods")

# add user
iadmin(action = "add", target = "user", arg2 = "Bob", arg3 = "rodsuser")

# add user password
iadmin(action = "modify", target = "user", arg2 = "Bob", arg3 = "password",
  arg4 = "pass")

# delete user
iadmin(action = "remove", target = "user", arg2 = "Bob")
\dontshow{\}) # examplesIf}
}
