% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ate.R
\name{findP1}
\alias{findP1}
\title{Compute the p.value from the distribution under H1}
\usage{
findP1(x, alternative = "two.sided")
}
\arguments{
\item{x}{the sample}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less"}
}
\description{
Compute the p.value from the distribution under H1
}
\examples{
set.seed(10)

# no effect
x <- rnorm(1e3) 
riskRegression:::findP1(x, alternative = "two.sided")
riskRegression:::findP1(x, alternative = "greater")
riskRegression:::findP1(x, alternative = "less")

# effect
x <- rnorm(1e3, mean = 1) 
riskRegression:::findP1(x, alternative = "two.sided")
riskRegression:::findP1(x, alternative = "greater") # pnorm(q = 0, mean = 1)
riskRegression:::findP1(x, alternative = "less")

x <- rnorm(1e3, mean = -1) 
riskRegression:::findP1(x, alternative = "two.sided") 
riskRegression:::findP1(x, alternative = "greater")
riskRegression:::findP1(x, alternative = "less") # pnorm(q = 0, mean = -1)

}

