% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qplot.predictCox.R
\name{qplot.predictCox}
\alias{qplot.predictCox}
\title{Plot predictions from a Cox model}
\usage{
qplot.predictCox(x, type = NULL, ci = FALSE, groupBy = "row",
  reduce.data = FALSE, plot = TRUE, conf.level = 0.95, digit = 2, ...)
}
\arguments{
\item{x}{object obtained with the function \code{predictCox}.}

\item{type}{the type of predicted value. Choices are \itemize{
\item \code{"hazard"} the baseline hazard function when
argument \code{newdata} is not used and the hazard function
when argument \code{newdata} is used.  \item \code{"cumhazard"}
the cumulative baseline hazard function when argument
\code{newdata} is not used and the cumulative hazard function
when argument \code{newdata} is used.  \item \code{"survival"}
the survival baseline hazard function when argument
\code{newdata} is not used and the cumulative hazard function
when argument \code{newdata} is used.  } Several choices can be
combined in a vector of strings that match (no matter the case)
strings \code{"hazard"},\code{"cumhazard"}, \code{"survival"}.}

\item{ci}{Logical. If \code{TRUE} display the confidence intervals for the predictions.}

\item{groupBy}{The grouping factor used to color the prediction curves. Can be \code{"row"}, \code{"strata"}, or \code{"covariates"}.}

\item{reduce.data}{Logical. If \code{TRUE} only the covariates that does take indentical values for all observations are displayed.}

\item{plot}{Logical. Should the graphic be plotted.}

\item{conf.level}{confidence level of the interval.}

\item{digit}{integer indicating the number of decimal places}

\item{...}{not used. Only for compatibility with the plot method.}
}
\description{
Plot predictions from a Cox model
}
\examples{
\dontrun{
library(survival)
library(ggplot2)

d <- sampleData(1e2, outcome = "survival")
m.cox <- coxph(Surv(time,event)~ X1 + X2 + X3,
                data = d, x = TRUE, y = TRUE)
dt.basehaz <- predictCox(m.cox)
ggplot(dt.basehaz, aes(x = time, y = survival)) + geom_point() + geom_line()

pred.cox <- predictCox(m.cox, newdata = d[1:4,],
  times = 1:5, type = "survival", se = TRUE, keep.newdata = TRUE)
plot(pred.cox)
plot(pred.cox, groupBy = "covariates")
plot(pred.cox, groupBy = "covariates", reduce.data = TRUE)


m.cox.strata <- coxph(Surv(time,event)~ strata(X1) + strata(X2) + X3 + X6,
data = d, x = TRUE, y = TRUE)
pred.cox.strata <- predictCox(m.cox.strata, newdata = d[c(1:5,10,50),],
time = 1:5, keep.newdata = TRUE)
plot(pred.cox.strata, type = "survival")
plot(pred.cox.strata, type = "survival", groupBy = "strata")
res <- plot(pred.cox.strata, type = "survival",
            groupBy = "covariates")

# customize display
res$plot + geom_point(size = 3)
}
}

