% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_risk_diff.R
\name{calc_risk_diff}
\alias{calc_risk_diff}
\title{Calculate Risk Differences with Robust Model Fitting and Boundary Detection}
\usage{
calc_risk_diff(
  data,
  outcome,
  exposure,
  adjust_vars = NULL,
  strata = NULL,
  link = "auto",
  alpha = 0.05,
  boundary_method = "auto",
  verbose = FALSE
)
}
\arguments{
\item{data}{A data frame containing all necessary variables}

\item{outcome}{Character string naming the binary outcome variable}

\item{exposure}{Character string naming the exposure variable of interest}

\item{adjust_vars}{Character vector of variables to adjust for (default: NULL)}

\item{strata}{Character vector of stratification variables (default: NULL)}

\item{link}{Character string specifying link function preference}

\item{alpha}{Significance level for confidence intervals (default: 0.05)}

\item{boundary_method}{Method for boundary case CIs: "auto", "profile", "bootstrap" (default: "auto")}

\item{verbose}{Logical indicating whether to print diagnostic messages}
}
\value{
A tibble of class "riskdiff_result" with additional boundary information:
\describe{
\item{exposure_var}{Character. Name of exposure variable}
\item{rd}{Numeric. Risk difference estimate}
\item{ci_lower}{Numeric. Lower confidence interval bound}
\item{ci_upper}{Numeric. Upper confidence interval bound}
\item{p_value}{Numeric. P-value for test of RD = 0}
\item{model_type}{Character. Link function used}
\item{n_obs}{Integer. Number of observations}
\item{on_boundary}{Logical. TRUE if MLE is on parameter space boundary}
\item{boundary_type}{Character. Type of boundary: "none", "upper_bound", "lower_bound", "separation"}
\item{boundary_warning}{Character. Warning message for boundary cases (if any)}
\item{ci_method}{Character. Method used for confidence intervals}
}
}
\description{
Calculates risk differences with enhanced boundary detection and robust
confidence interval methods. Version 0.2.0 adds explicit detection of
boundary cases where the MLE lies at the edge of the parameter space,
providing more reliable inference in these situations.
}
\details{
\subsection{New in Version 0.2.0: Boundary Detection}{

This version adds explicit detection of boundary cases where the maximum
likelihood estimate lies at the edge of the valid parameter space. This
commonly occurs with:
\itemize{
\item \strong{Identity link models}: When fitted probabilities approach 0 or 1
\item \strong{Log link models}: When fitted probabilities approach 1
\item \strong{Logit link models}: When complete or quasi-separation occurs
}
}

\subsection{Statistical Theory}{

When the MLE is on the boundary, standard asymptotic theory may not apply:
\itemize{
\item Wald confidence intervals can be too narrow or asymmetric
\item Standard errors from the information matrix may be inappropriate
\item The sampling distribution may not be normal
}
}

\subsection{Robust Inference Methods}{

For boundary cases, the function implements:
\itemize{
\item \strong{Profile likelihood intervals} (preferred when computationally feasible)
\item \strong{Bootstrap confidence intervals} (robust but computationally intensive)
\item \strong{Modified Wald intervals} with boundary adjustments
}
}
}
\examples{
data(cachar_sample)

# Basic usage with boundary detection
result <- calc_risk_diff(
  data = cachar_sample,
  outcome = "abnormal_screen",
  exposure = "smoking"
)

# Check for boundary cases
if (any(result$on_boundary)) {
  cat("Boundary case detected!\n")
  cat("Boundary type:", result$boundary_type[result$on_boundary], "\n")
  cat("CI method used:", result$ci_method[result$on_boundary], "\n")
}

# Force profile likelihood CIs for all cases
result_profile <- calc_risk_diff(
  data = cachar_sample,
  outcome = "abnormal_screen",
  exposure = "smoking",
  boundary_method = "profile"
)

}
\references{
Marschner IC, Gillett AC (2012). Relative Risk Regression: Reliable and
Flexible Methods for Log-Binomial Models. Biostatistics, 13(1), 179-192.

Venzon DJ, Moolgavkar SH (1988). A Method for Computing Profile-Likelihood-Based
Confidence Intervals. Journal of the Royal Statistical Society, 37(1), 87-94.

Donoghoe MW, Marschner IC (2018). logbin: An R Package for Relative Risk
Regression Using the Log-Binomial Model. Journal of Statistical Software,
86(9), 1-22. doi:10.18637/jss.v086.i09
}
