% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_icons.R
\name{plot_icons}
\alias{plot_icons}
\title{Plot an icon array of a population.}
\usage{
plot_icons(prev = num$prev, sens = num$sens, mirt = NA, spec = num$spec,
  fart = NA, N = freq$N, type = "array", ident.order = c("hi", "mi",
  "fa", "cr"), icon.colors = pal[c("hi", "mi", "fa", "cr")],
  icon.types = 22, icon.border.col = grey(0.1, 0.5),
  icon.border.lwd = 1.5, transparency = 0.5, icon.size = NULL,
  block.d = NULL, border.d = 0.1, block.size.row = 10,
  block.size.col = 10, nblocks.row = NULL, nblocks.col = NULL,
  fill.array = "left", fill.blocks = "rowwise", show.accu = TRUE,
  w.acc = 0.5, title.lbl = txt$scen.lbl, type.lbls = txt[c("hi.lbl",
  "mi.lbl", "fa.lbl", "cr.lbl")], cex.lbl = 0.85)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{N}{The number of individuals in the population.
A suitable value of \code{\link{N}} is computed, if not provided.
If N is 100,000 or greater it is reduced to 10,000
for the array types if the frequencies allow it.}

\item{type}{The icons can be arranged in different ways
resulting in different types of displays:

\enumerate{

  \item \code{type = "array"}: Icons are plotted in a
  classical icon array (default).
  Icons can be arranged in blocks using \code{block.d}.
  The order of filling the array can be customized using
  \code{fill.array} and \code{fill.blocks}.

  \item \code{type = "shuffledarray"}: Icons are plotted in an
  icon array, but positions are shuffled (randomized).
  Icons can be arranged in blocks using \code{block.d}.
  The order of filling the array can be customized using
  \code{fill.array} and \code{fill.blocks}.

  \item \code{type = "mosaic"}: Icons are ordered like in a mosaic plot.
  The area size displays the relative proportions of their frequencies.

  \item \code{type = "fillequal"}: Icons are positioned into equally sized blocks.
  Thus, their density reflects the relative proportions of their frequencies.

  \item \code{type = "fillleft"}: Icons are randomly filled from the left.

  \item \code{type = "filltop"}: Icons are randomly filled from the top.

  \item \code{type = "scatter"}: Icons are randomly scattered into the plot.

}}

\item{ident.order}{The order in which icon identities
(i.e, hi, mi, fa, and cr) are plotted.
Default: \code{ident.order = c("hi", "mi", "fa", "cr")}}

\item{icon.colors}{Specifies the icon colors as a vector.}

\item{icon.types}{Specifies the appearance of the icons as a vector.
Accepts values from 1 to 25 (see \code{?points}).}

\item{icon.border.col}{Specifies the border color of icons (if applicable).}

\item{icon.border.lwd}{Specifies the border width of icons (if applicable).}

\item{transparency}{Specifies the transparency for overlapping icons
(not \code{type} "array" and "shuffledarray").}

\item{icon.size}{Manually specifies the size of the icons via \code{cex}
(calculated dynamically by default.)}

\item{block.d}{The distance between blocks
(does not apply to "filleft", "filltop", and "scatter")}

\item{border.d}{The distance of icons to the border.


Additional options allow to control the arrangement of the arrays
(\code{type} "array" and "shuffledarray"):}

\item{block.size.row}{specifies how many icons should be in each block row.}

\item{block.size.col}{specifies how many icons should be in each block column.}

\item{nblocks.row}{specifies how many blocks there are in each row.  Is calculated by default.}

\item{nblocks.col}{specifies how many blocks are there in each column.  Is calculated by default.}

\item{fill.array}{specifies how the blocks are filled into the array
(Options "left" (default) and "top").}

\item{fill.blocks}{specifies how icons within blocks are filled
(Options: \code{fill.blocks = "rowwise"} (default) and \code{fill.blocks = "colwise"})}

\item{show.accu}{Option for showing current
accuracy metrics \code{\link{accu}} in the plot.
Default: \code{show.accu = TRUE}.}

\item{w.acc}{Weigthing parameter \code{w} used to compute
weighted accuracy \code{w.acc} in \code{\link{comp_accu}}.
Default: \code{w.acc = .50}.


Various other options allow the customization of text labels and colors:}

\item{title.lbl}{Text label to set plot title.}

\item{type.lbls}{Text labels for icon types to be displayed in legend.}

\item{cex.lbl}{Scaling factor for the size of text labels
(e.g., on axes, legend, margin text).
Default: \code{cex.lbl = .85}.}
}
\description{
\code{plot_icons} plots a population of which individual's
condition has been classified correctly or incorrectly as icons
from a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}})
or existing frequency information \code{\link{freq}}
and a population size of \code{\link{N}} individuals.
}
\details{
If probabilities are provided, a new list of
natural frequencies \code{\link{freq}} is computed by \code{\link{comp_freq}}.
By contrast, if no probabilities are provided,
the values currently contained in \code{\link{freq}} are used.
By default, \code{\link{comp_freq}} rounds frequencies to nearest integers
to avoid decimal values in \code{\link{freq}}.
}
\examples{
# ways to work:
plot_icons()  # => plots icon array for default population (with default type = "array")
plot_icons(type = "shuffledarray")  # => icon array with shuffled IDs

plot_icons(type = "mosaic",    N = 1000)  # => areas as in mosaic plot
plot_icons(type = "fillequal", N = 1000)  # => areas of equal size (density reflects probability)
plot_icons(type = "fillleft",  N = 1000)  # => icons filled from left to right (in columns)
plot_icons(type = "filltop",   N = 1000)  # => icons filled from top to bottom (in rows)

plot_icons(icon.types = c(21,23,24,23),
               block.size.row = 5, block.size.col = 5, #nblocks.row = 2, nblocks.col = 2,
               block.d = 0.5, border.d = 0.9)
plot_icons(type = "scatter",   N = 1000)  # => icons randomly scattered.

# some variants:
plot_icons(N = 800, type = "array", icon.types = c(21,22,23,24),
           block.d = 0.5, border.d = 0.5)

plot_icons(N = 1250, sens = 0.9, spec = 0.9, prev = 0.9,
               icon.types = c(21,23,24,23),
               block.size.row = 10, block.size.col = 5,
               nblocks.row = 5, nblocks.col = 5,
               block.d = 0.8,
               border.d = 0.2,
               fill.array = "top")
plot_icons(N = 800, type = "shuffledarray", icon.types = c(21,23,24,22),
           block.d = 0.5, border.d = 0.5)

plot_icons(N = 800, type = "shuffledarray", icon.types = c(21,23,24,22),
           icon.border.col = grey(.33, .99), icon.border.lwd = 3)

plot_icons(N = 800, type = "fillequal", icon.types = c(21,22,22,21),
           icon.border.lwd = .5, cex = 3)


}
\seealso{
Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_curve}}, \code{\link{plot_fnet}},
  \code{\link{plot_mosaic}}, \code{\link{plot_plane}},
  \code{\link{plot_tree}}
}
