% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{ppod}
\alias{ppod}
\alias{baserate_dec.pos}
\alias{PR}
\title{The proportion (or baseline) of a positive decision.}
\format{An object of class \code{numeric} of length 1.}
\usage{
ppod
}
\description{
\code{ppod} defines the proportion (baseline probability or rate):
a decision being \code{positive} (but not necessarily true).
}
\details{
Understanding or obtaining the proportion of positive decisions \code{ppod}:

\itemize{

\item Definition:
  \code{ppod} is the (non-conditional) probability:

\code{ppod = p(decision = positive)}

or the base rate (or baseline probability)
  of a decision being positive (but not necessarily true).

\item Perspective:
  \code{ppod} classifies a population of \code{\link{N}} individuals
  by decision (\code{ppod = dec.pos/N}).

\code{ppod} is the "by decision" counterpart to \code{\link{prev}}
  (which adopts a "by condition" perspective).

\item Alternative names:
  base rate of positive decisions (\code{PR}),
  proportion predicted or diagnosed,
  rate of decision \code{= positive} cases

\item In terms of frequencies,
  \code{ppod} is the ratio of
  \code{\link{dec.pos}} (i.e., \code{\link{hi} + \link{fa}})
  divided by \code{\link{N}} (i.e.,
  \code{\link{hi} + \link{mi}} + \code{\link{fa} + \link{cr}}):

\code{ppod = dec.pos/N = (hi + fa)/(hi + mi + fa + cr)}

\item Dependencies:
  \code{ppod} is a feature of the decision process
  or diagnostic procedure.

However, the conditional probabilities
  \code{\link{sens}}, \code{\link{mirt}},
  \code{\link{spec}}, \code{\link{fart}},
  \code{\link{PPV}}, and \code{\link{NPV}}
  also depend on the condition's prevalence \code{\link{prev}}.

}
}
\examples{
ppod <- .50     # => sets a rate of positive decisions of 50\%
ppod <- 50/100  # => (decision = TRUE) for 50 out of 100 individuals
is_prob(ppod)   # => TRUE (as ppod is a probability)

}
\references{
Consult \href{https://en.wikipedia.org/wiki/Positive_and_negative_predictive_values}{Wikipedia} for additional information.
}
\seealso{
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probability inputs.

Other probabilities: \code{\link{FDR}}, \code{\link{FOR}},
  \code{\link{NPV}}, \code{\link{PPV}}, \code{\link{fart}},
  \code{\link{mirt}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}
}
\keyword{datasets}
