% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{mi}
\alias{mi}
\alias{FN}
\alias{type-II-errors}
\title{Frequency of misses or false negatives (FN).}
\format{An object of class \code{numeric} of length 1.}
\usage{
mi
}
\description{
\code{mi} is the frequency of misses
or false negatives (\code{FN})
in a population of \code{\link{N}} individuals.
}
\details{
Definition:
\code{mi} is the frequency of individuals for which
\code{Condition = TRUE} and \code{Decision = FALSE} (negative).

\code{mi} is a measure of incorrect classifications
(type-II errors), not an individual case.

Relationships:
\enumerate{
\item to probabilities:
The frequency \code{mi} depends on the miss rate \code{\link{mirt}}
(aka. false negative rate, FNR)
and is conditional on the prevalence \code{\link{prev}}.

\item to other frequencies:
In a population of size \code{\link{N}}
the following relationships hold:

\itemize{

\item \code{\link{N} = \link{cond_true} + \link{cond_false}} (by condition)

\item \code{\link{N} = \link{dec_pos} + \link{dec_neg}} (by decision)

\item \code{\link{N} = \link{dec_cor} + \link{dec_err}} (by correspondence of decision to condition)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
   }
}
}
\seealso{
\code{\link{mirt}} is the probability or rate of misses;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{is_freq}} verifies frequencies.

Other essential parameters: \code{\link{cr}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}

Other frequencies: \code{\link{N}},
  \code{\link{cond_false}}, \code{\link{cond_true}},
  \code{\link{cr}}, \code{\link{dec_cor}},
  \code{\link{dec_err}}, \code{\link{dec_neg}},
  \code{\link{dec_pos}}, \code{\link{fa}}, \code{\link{hi}}
}
\concept{essential parameters}
\concept{frequencies}
\keyword{datasets}
