% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal}
\alias{pal}
\title{List current values of scenario color palette.}
\format{
An object of class \code{character} of length 16.
}
\usage{
pal
}
\description{
\code{pal} is initialized to a vector of named elements (colors)
to define the scenario color scheme that is
used throughout the \bold{riskyr} package.
}
\details{
All color information corresponding to the current scenario
is stored as named colors in a vector \code{pal}.
To change a color, assign a new color to an existing element name.

\code{pal} currently contains colors with the following names:

\enumerate{

\item \code{N} Color representing the \emph{population} of \code{\link{N}} cases or individuals.

\item \code{cond_true} Color representing cases of \code{\link{cond_true}}, for which the current condition is \code{TRUE}.

\item \code{cond_false} Color representing cases of in \code{\link{cond_false}}, for which the current condition is \code{FALSE}.

\item \code{dec_pos} Color representing cases of \code{\link{dec_pos}}, for which the current decision is \code{positive}.

\item \code{dec_neg} Color representing cases in \code{\link{dec_neg}}, for which the current decision is \code{negative}.

\item \code{dec_cor} Color representing cases of correct decisions \code{\link{dec_cor}}, for which the current decision is \code{accurate}.

\item \code{dec_err} Color representing cases of erroneous decisions \code{\link{dec_err}}, for which the current decision is \code{inaccurate}.

\item \code{hi} Color representing \emph{hits} or true positives in \code{\link{hi}}
(i.e., correct cases for which the current condition is TRUE and the decision is positive).

\item \code{mi} Color representing \emph{misses} or false negatives in \code{\link{mi}}
(i.e., incorrect cases for which the current condition is TRUE but the decision is negative).

\item \code{fa} Color representing \emph{false alarms} or false positives in \code{\link{fa}}
(i.e., incorrect cases for which the current condition is FALSE but the decision is positive).

\item \code{cr} Color representing \emph{correct rejections} or true negatives in \code{\link{cr}}
(i.e., correct cases for which the current condition is FALSE and the decision is negative).

\item \code{ppv} Color representing \emph{positive predictive values} \code{\link{PPV}} (i.e., the conditional probability that
the condition is TRUE, provided that the decision is positive).

\item \code{npv} Color representing \emph{negative predictive values} \code{\link{NPV}} (i.e., the conditional probability that
the condition is FALSE, provided that the decision is negative).

\item \code{txt} Color used for text labels.

\item \code{brd} Color used for borders.

\item \code{bg} Color used for plot background (used to set \code{par(bg = bg_col)}).

}

Note that color names for frequencies correspond to frequency names,
but are different for probabilities (which are written in lowercase
and only \code{\link{PPV}} and \code{\link{NPV}} have assigned colors).
}
\examples{
pal        # shows all color names and current values
pal["hi"]  # shows the current color for hits (true positives, TP)
pal["hi"] <- "gold"  # defines a new color for hits (true positives, TP)

}
\seealso{
\code{\link{init_pal}} initializes color information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{txt}} contains current text information;
\code{\link{init_txt}} initializes text information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other lists containing current scenario information: 
\code{\link{accu}},
\code{\link{freq}},
\code{\link{num}},
\code{\link{pal_bwp}},
\code{\link{pal_bw}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}},
\code{\link{prob}},
\code{\link{txt_TF}},
\code{\link{txt_org}},
\code{\link{txt}}
}
\concept{lists containing current scenario information}
\keyword{datasets}
