% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_t_index_calculation.R
\name{inner_t_index_calculation}
\alias{inner_t_index_calculation}
\title{Calculates time-dependent index when nodes weights or barriers passability are changing - not for exporting}
\usage{
inner_t_index_calculation(
  graph,
  barriers_metadata,
  id_barrier,
  year,
  pass_u,
  pass_d,
  weights_metadata,
  weight,
  nodes_id,
  parallel,
  ncores,
  index_type,
  index_mode,
  c_ij_flag,
  B_ij_flag,
  dir_fragmentation_type,
  pass_confluence,
  field_B,
  dir_distance_type,
  disp_type,
  param_u,
  param_d,
  param,
  param_l
)
}
\arguments{
\item{graph}{an object of class igraph. Can be both directed or undirected.}

\item{barriers_metadata}{data.frame that must contain a column having the same name as the 'id_barrier' attribute of the graph,
and two columns with the corresponding upstream and downstream improved passabilities (see pass_u and pass_d), and a column with the year
passability was changed. This data frame can be obtained from easily-formatted data with the function \code{t_passability_sequencer}.}

\item{id_barrier}{graph edges numeric attribute used to label barriers. Default is \code{"id_barrier"}. It should be present in the 'barriers metadata' input as well.}

\item{year}{field of the 'barriers metadata' where temporal information on the changes in passabiity is stored.}

\item{pass_u}{check index_calculation function.}

\item{pass_d}{check index_calculation function.}

\item{weights_metadata}{data.frame that must contain a column having the same name as the 'nodes_id' attribute of the graph,
a column with he corresponding weight information (see 'weight' parameter), and a column with the year
weight was changed. This data frame can be obtained from easily-formatted data with the function \code{t_weight_sequencer}.}

\item{weight}{param weight graph vertex attribute used to assign weights to the reaches (nodes). Default is \code{"length"}.}

\item{nodes_id}{graph vertex attribute used to univoquely label reaches (nodes). Default is \code{"name"}.}

\item{parallel}{logical value to flag if parallel option is to be used.}

\item{ncores}{define how many cores are used in parallel processing. Active only when \code{parallel = TRUE}}

\item{index_type}{check index_calculation function.}

\item{index_mode}{check index_calculation function.}

\item{c_ij_flag}{check index_calculation function.}

\item{B_ij_flag}{check index_calculation function.}

\item{dir_fragmentation_type}{check index_calculation function.}

\item{pass_confluence}{check index_calculation function.}

\item{field_B}{check index_calculation function.}

\item{dir_distance_type}{check index_calculation function.}

\item{disp_type}{check index_calculation function.}

\item{param_u}{check index_calculation function.}

\item{param_d}{check index_calculation function.}

\item{param}{check index_calculation function.}

\item{param_}{check index_calculation function.}
}
\value{
a data.frame with a 'year' field and related connectity index.
If \code{index_type = "reach"}, the data.frame is organized by 'year' and 'name'.
}
\description{
Calculates time-dependent index when nodes weights or barriers passability are changing - not for exporting
}
\keyword{internal}
