% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{riverdirection}
\alias{riverdirection}
\title{River Direction}
\usage{
riverdirection(startseg, endseg, startvert, endvert, rivers,
  flowconnected = FALSE, stopiferror = TRUE, algorithm = NULL)
}
\arguments{
\item{startseg}{Segment number of the start of the route}

\item{endseg}{Segment number of the end of the route}

\item{startvert}{Vertex number of the start of the route}

\item{endvert}{Vertex number of the end of the route}

\item{rivers}{The river network object to use}

\item{flowconnected}{If \code{TRUE}, only returns direction if the two input segments are flow-connected.  Defaults to \code{FALSE}.}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
the function will return \code{NA} in the appropriate entry.  Defaults to \code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
Direction: "up", "down", or "0" (character).  Returns NA if \code{flowconnected==TRUE} and the two segments are not flow-connected.
}
\description{
Calculates direction of travel between two points.  Only works
  if river mouth (lowest point) has been specified (see \link{setmouth}).
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk)

# Mouth must be specified
Gulk$mouth$mouth.seg <- 1
Gulk$mouth$mouth.vert <- 1

plot(x=Gulk)
riverdirection(startseg=6, endseg=3, startvert=40, endvert=40, rivers=Gulk)
}
\author{
Matt Tyers
}
\seealso{
\link{setmouth}
}

