% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectroute_riverdistance.R
\name{detectroute}
\alias{detectroute}
\title{Detect Route}
\usage{
detectroute(
  start,
  end,
  rivers,
  verbose = FALSE,
  stopiferror = TRUE,
  algorithm = NULL
)
}
\arguments{
\item{start}{Segment number of the start of the route}

\item{end}{Segment number of the end of the route}

\item{rivers}{The river network object to use}

\item{verbose}{Whether or not to print all routes being considered (used for 
error checking).  Defaults to FALSE.}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
\code{detectroute()} will return \code{NA}.  Defaults to \code{TRUE}.}

\item{algorithm}{Which route detection algorithm to use.  If set to \code{NULL} (the default), the function will automatically make a selection.  Choices are:
\itemize{
\item Setting \code{algorithm="sequential"} will be quite slow, and may give inaccurate results in the event of braiding.  This algorithm returns the first complete route detected, which may not be the shortest.  This algorithm is not recommended in almost all cases, but is retained as an option for certain checks.  It will not be used unless specified.
\item Setting \code{algorithm="Dijkstra"} will be much faster, and will return the shortest route in the event of braiding.  If braiding is present or unknown, this will be the algorithm automatically chosen.
\item Setting \code{algorithm="segroutes"} will be the fastest of all, but will only return results in a non-braided network.  This will be the algorithm automatically selected if segment routes are present - see \link{buildsegroutes}.}}
}
\value{
A vector of segment numbers corresponding to the ordered route.
}
\description{
Called internally within \link{riverdistance}.  Detects the 
  sequential route from one river network segment to another.
}
\examples{
data(Gulk)
plot(x=Gulk, cex=1)

detectroute(start=6, end=14, rivers=Gulk)

tstart <- Sys.time()
detectroute(start=120, end=111, rivers=abstreams, algorithm="sequential")
tend <- Sys.time()
tend - tstart

data(abstreams)
tstart <- Sys.time()
detectroute(start=120, end=111, rivers=abstreams, algorithm="Dijkstra")
tend <- Sys.time()
tend - tstart

tstart <- Sys.time()
detectroute(start=120, end=111, rivers=abstreams, algorithm="segroutes")
tend <- Sys.time()
tend - tstart
}
\author{
Matt Tyers
}
