\name{indexBox}
\alias{indexBox}
\title{
Get indices of adjacent entries in array
}
\description{
Determines the relative vector positions of entries which are adjacent in an array.
}
\usage{
indexBox(upp, lwr, dim)
}
\arguments{
  \item{upp}{
A vector of non-negative integers, giving the distance in the positive direction from the centre in each co-ordinate.
}
  \item{lwr}{
A vector of non-positive integers, giving the negative distance from the centre.
}
  \item{dim}{
integer vector of array dimensions.
}
}
\details{
Given a particular cell in an array, which are the entries within (for example) 1 unit in any direction?  This function gives the (relative) value of such indices.  See examples.
}
\value{
An integer vector giving relative positions of the indices.
}
\author{
Robin Evans
}

\seealso{
\code{\link[rje]{arrayInd}}.
}
\examples{
arr = array(1:144, dim=c(3,4,3,4))
arr[2,2,2,3]
# which are entries within 1 unit each each direction of 2,2,2,3?

inds = 89 + indexBox(1,-1,c(3,4,3,4))
inds = inds[inds > 0 & inds <= 144]
arrayInd(inds, c(3,4,3,4))

# what about just in second dimension?
inds = 89 + indexBox(c(0,1,0,0),c(0,-1,0,0),c(3,4,3,4))
inds = inds[inds > 0 & inds <= 144]
arrayInd(inds, c(3,4,3,4))
}
\keyword{array}
