/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.utils.Crc32;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.NoManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils$
implements Logging,
ScalaObject {
    public static final Utils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    public /* synthetic */ Charset readFileAsString$default$2() {
        return Charset.defaultCharset();
    }

    public Runnable runnable(Function0<Object> fun$1) {
        return new anon.1(fun$1);
    }

    public Thread daemonThread(Runnable runnable) {
        return this.newThread(runnable, true);
    }

    public Thread daemonThread(String name, Runnable runnable) {
        return this.newThread(name, runnable, true);
    }

    public Thread daemonThread(String name, Function0<Object> fun) {
        return this.daemonThread(name, this.runnable(fun));
    }

    public Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new anon.2());
        return thread;
    }

    /*
     * WARNING - void declaration
     */
    public Thread newThread(Runnable runnable, boolean daemon) {
        void var3_3;
        Thread thread = new Thread(runnable);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new anon.3());
        return var3_3;
    }

    public byte[] readBytes(ByteBuffer buffer) {
        return this.readBytes(buffer, 0, buffer.limit());
    }

    public byte[] readBytes(ByteBuffer buffer, int offset, int size2) {
        Object object;
        byte[] dest = new byte[size2];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + offset, dest, 0, size2);
            object = BoxedUnit.UNIT;
        } else {
            buffer.mark();
            buffer.get(dest);
            object = buffer.reset();
        }
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public Properties loadProps(String filename) {
        void var3_3;
        FileInputStream propStream = new FileInputStream(filename);
        Properties props = new Properties();
        props.load(propStream);
        return var3_3;
    }

    public FileChannel openChannel(File file, boolean mutable) {
        return mutable ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, Object> log2, Function0<Object> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log2.apply(throwable.getMessage(), throwable);
        }
    }

    public boolean equal(ByteBuffer b1$1, ByteBuffer b2$1) {
        Object object = new Object();
        boolean exceptionResult1 = false;
        try {
            if (b1$1.position() != b2$1.position()) {
                return false;
            }
            if (b1$1.remaining() != b2$1.remaining()) {
                return false;
            }
            Predef$.MODULE$.intWrapper(0).until(b1$1.remaining()).foreach$mVc$sp(new anonfun.equal.1(b1$1, b2$1, object));
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                exceptionResult1 = BoxesRunTime.unboxToBoolean(nonLocalReturnControl.value());
                return exceptionResult1;
            }
            throw nonLocalReturnControl;
        }
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public void croak(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public void rm(String file) {
        this.rm(new File(file));
    }

    public void rm(Seq<String> files) {
        files.map(new anonfun.rm.1(), Seq$.MODULE$.canBuildFrom());
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Predef$.MODULE$.refArrayOps((Object[])files).foreach(new anonfun.rm.2());
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object mbean, String name$1) {
        void var3_3;
        boolean exceptionResult2 = false;
        try {
            Boolean bl;
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name$1);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                bl = BoxesRunTime.boxToBoolean(true);
            }
            exceptionResult2 = BoxesRunTime.unboxToBoolean(bl);
            return (boolean)var3_3;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.registerMBean.1(name$1), (Function0<Throwable>)new anonfun.registerMBean.2(exception));
            return (boolean)var3_3;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public long readUnsignedInt(ByteBuffer buffer, int index2) {
        return (long)buffer.getInt(index2) & 0xFFFFFFFFL;
    }

    public void writetUnsignedInt(ByteBuffer buffer, long value2) {
        buffer.putInt((int)(value2 & 0xFFFFFFFFL));
    }

    public void writeUnsignedInt(ByteBuffer buffer, int index2, long value2) {
        buffer.putInt(index2, (int)(value2 & 0xFFFFFFFFL));
    }

    public long crc32(byte[] bytes) {
        return this.crc32(bytes, 0, bytes.length);
    }

    public long crc32(byte[] bytes, int offset, int size2) {
        Crc32 crc = new Crc32();
        crc.update(bytes, offset, size2);
        return crc.getValue();
    }

    public int hashcode(Seq<Object> as) {
        if (as == null) {
            return 0;
        }
        int h = 1;
        int i = 0;
        while (i < as.length()) {
            if (as.apply(i) == null) continue;
            h = 31 * h + as.apply(i).hashCode();
            ++i;
        }
        return h;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Map<K, List<V>> groupby(Iterable<V> vals, Function1<V, K> f$1) {
        void var3_3;
        HashMap m$1 = new HashMap();
        vals.foreach(new anonfun.groupby.1(f$1, m$1));
        return var3_3;
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        if (n == -1) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        if (BoxesRunTime.boxToInteger(n) instanceof Integer) {
            return n;
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    public <V> V notNull(V v) {
        if (v == null) {
            throw new KafkaException("Value cannot be null.");
        }
        return v;
    }

    public Tuple2<String, Integer> parseHostPort(String hostport) {
        String[] splits = hostport.split(":");
        return new Tuple2<String, Integer>(splits[0], BoxesRunTime.boxToInteger(Predef$.MODULE$.augmentString(splits[1]).toInt()));
    }

    public String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        if ("".equals(str)) {
            return map2;
        }
        String[][] keyVals = (String[][])Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*")).map(new anonfun.2(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.arrayType(ClassManifest$.MODULE$.classType(String.class))));
        return Predef$.MODULE$.refArrayOps(Predef$.MODULE$.refArrayOps((Object[])keyVals).map(new anonfun.parseCsvMap.1(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, ClassManifest$.MODULE$.classType(String.class), Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(String.class)}))))).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (WrappedArray<Object>)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*")).filter(new anonfun.parseCsvList.1()));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className);
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map(new anonfun.3(), Seq$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(Class.class, NoManifest$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))));
        return (T)constructor.newInstance((Object[])args.toArray(Manifest$.MODULE$.Object()));
    }

    public boolean nullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll$1) {
        Stream stream = package$.MODULE$.Stream().continually(new anonfun.1()).flatMap(new anonfun.4(coll$1), Stream$.MODULE$.canBuildFrom());
        return stream.iterator();
    }

    public String readFileAsString(String path, Charset charset) {
        FileInputStream stream = new FileInputStream(new File(path));
        String exceptionResult3 = null;
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            exceptionResult3 = charset.decode(bb).toString();
            return exceptionResult3;
        }
        finally {
            stream.close();
        }
    }

    public int abs(int n) {
        return n & Integer.MAX_VALUE;
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (s.endsWith(oldSuffix)) {
            return new StringBuilder().append((Object)s.substring(0, s.length() - oldSuffix.length())).append((Object)newSuffix).toString();
        }
        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{oldSuffix, s})));
    }

    public File createFile(String path) {
        File f = new File(path);
        boolean created = f.createNewFile();
        if (created) {
            return f;
        }
        throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to create file %s.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{path})));
    }

    public String asString(Properties props) {
        StringWriter writer = new StringWriter();
        props.store(writer, "");
        return writer.toString();
    }

    public Properties readProps(String s, Properties defaults) {
        StringReader reader = new StringReader(s);
        Properties props = new Properties(defaults);
        props.load(reader);
        return props;
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock2, Function0<T> fun) {
        lock2.lock();
        Object exceptionResult4 = null;
        try {
            T t = fun.apply();
            lock2.unlock();
            return t;
        }
        catch (Throwable throwable) {
            lock2.unlock();
            throw throwable;
        }
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

