% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compile4float64}
\alias{compile4float64}
\title{Enable compiling of user-defined operators using float 64bits precision.}
\usage{
compile4float64()
}
\value{
None
}
\description{
Set up \code{rkeops} compile options to compile user-defined operators that use
float 64bits precision in computation.
}
\details{
\strong{Note:} Default behavior is to compile operators operators that use
float 32bits precision in computation. Hence, if you do not modify \code{rkeops}
options, you have to call the function \code{compile4float64} to
compile operators using float 64bits precision.

Using float 64bits (or double) precision is likely to result in a loss of
performance regarding computing time on GPU. If you want to get the best
performance but worry about computation precision, you can use float 32bits
precision and compensated sums that are implemented in KeOps.
}
\examples{
library(rkeops)
compile4float64()
}
\seealso{
\code{\link[=compile4float32]{compile4float32()}}
}
\author{
Ghislain Durif
}
