% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{MultiplicativeUDF.Kernel}
\alias{MultiplicativeUDF.Kernel}
\title{Multiplicative User Defined Function (UDF) Kernel}
\usage{
MultiplicativeUDF.Kernel(lengthscale, kernel.function)
}
\arguments{
\item{lengthscale}{a vector for the positive length scale parameters}

\item{kernel.function}{user defined kernel function}
}
\value{
A Multiplicative User Defined Function (UDF) Kernel Class Object.
}
\description{
This function specifies the Multiplicative kernel with the user defined R function.
}
\details{
The Multiplicative User Defined Function (UDF) kernel is given by 
\deqn{k(r)=\prod_{i=1}^{p}f(r_{i}),}{k(r) = prod_{i=1}^{p} f(r_i),}
where \eqn{f}{f} is the user defined kernel function that takes \eqn{r_{i}^2}{r_i^2} as input, 
where \deqn{r_{i}(x,x^{\prime})=\sqrt{\left(\frac{x_{i}-x_{i}^{\prime}}{l_{i}}\right)^2}}{r_i(x,x') = sqrt([(x_i - x'_i) / l_i]^2)} 
is the dimension-wise euclidean distances between \eqn{x}{x} and \eqn{x^{\prime}}{x'} weighted by
the length scale parameters \eqn{l_{i}}{l_i}'s.
}
\examples{
n <- 5
p <- 3
X <- matrix(rnorm(n*p), ncol=p)
lengthscale <- c(1:p)

kernel.function <- function(sqdist) {return (exp(-sqrt(sqdist)))} 

# approach 1
kernel <- MultiplicativeUDF.Kernel(lengthscale, kernel.function=kernel.function)
Evaluate.Kernel(kernel, X)

# approach 2
kernel <- Get.Kernel(lengthscale, type="MultiplicativeUDF", 
                     parameters=list(kernel.function=kernel.function))
Evaluate.Kernel(kernel, X) 

}
\references{
Duvenaud, D. (2014). \emph{The kernel cookbook: Advice on covariance functions}.

Rasmussen, C. E. & Williams, C. K. (2006). \emph{Gaussian Processes for Machine Learning}. The MIT Press.
}
\seealso{
\link{UDF.Kernel}, \link{Get.Kernel}, \link{Evaluate.Kernel}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
