% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{invoke}
\alias{invoke}
\title{Invoke a function with a list of arguments}
\usage{
invoke(.fn, .args = list(), ..., .env = caller_env(), .bury = c(".fn",
  ""))
}
\arguments{
\item{.fn}{A function to invoke. Can be a function object or the
name of a function in scope of \code{.env}.}

\item{.args, ...}{List of arguments (possibly named) to be passed to
\code{.fn}.}

\item{.env}{The environment in which to call \code{.fn}.}

\item{.bury}{A character vector of length 2. The first string
specifies which name should the function have in the call
recorded in the evaluation stack. The second string specifies a
prefix for the argument names. Set \code{.bury} to \code{NULL} if you
prefer to inline the function and its arguments in the call.}
}
\description{
Normally, you invoke a R function by typing arguments manually. A
powerful alternative is to call a function with a list of arguments
assembled programmatically. This is the purpose of \code{invoke()}.
}
\details{
Technically, \code{invoke()} is basically a version of \code{\link[base:do.call]{base::do.call()}}
that creates cleaner call traces because it does not inline the
function and the arguments in the call (see examples). To achieve
this, \code{invoke()} creates a child environment of \code{.env} with \code{.fn}
and all arguments bound to new symbols (see \code{\link[=env_bury]{env_bury()}}). It then
uses the same strategy as \code{\link[=eval_bare]{eval_bare()}} to evaluate with minimal
noise.
}
\examples{
# invoke() has the same purpose as do.call():
invoke(paste, letters)

# But it creates much cleaner calls:
invoke(call_inspect, mtcars)

# and stacktraces:
fn <- function(...) sys.calls()
invoke(fn, list(mtcars))

# Compare to do.call():
do.call(call_inspect, mtcars)
do.call(fn, list(mtcars))


# Specify the function name either by supplying a string
# identifying the function (it should be visible in .env):
invoke("call_inspect", letters)

# Or by changing the .bury argument, with which you can also change
# the argument prefix:
invoke(call_inspect, mtcars, .bury = c("inspect!", "col"))
}
