% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{dictionary}
\alias{dictionary}
\alias{as_dictionary}
\alias{is_dictionary}
\title{Create a dictionary}
\usage{
as_dictionary(x, lookup_msg = NULL, read_only = FALSE)

is_dictionary(x)
}
\arguments{
\item{x}{An object for which you want to find associated data.}

\item{lookup_msg}{An error message when your data source is
accessed inappropriately (by position rather than name).}

\item{read_only}{Whether users can replace elements of the
dictionary.}
}
\description{
Dictionaries are a concept of types modelled after R
environments. Dictionaries are containers of R objects that:
\itemize{
\item Contain uniquely named objects.
\item Can only be indexed by name. They must implement the extracting
operators \code{$} and \code{[[}. The latter returns an error when indexed
by position because dictionaries are not vectors (they are
unordered).
\item Report a clear error message when asked to extract a name that
does not exist. This error message can be customised with the
\code{lookup_msg} constructor argument.
}
}
\details{
Dictionaries are used within the tidy evaluation framework for
creating pronouns that can be explicitly referred to from captured
code. See \code{\link[=eval_tidy]{eval_tidy()}}.
}
