% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{is_quosure}
\alias{is_quosure}
\alias{is_quosureish}
\title{Is an object a quosure or quosure-like?}
\usage{
is_quosure(x)

is_quosureish(x, scoped = NULL)
}
\arguments{
\item{x}{An object to test.}

\item{scoped}{A boolean indicating whether the quosure or formula
is scoped, that is, has a valid environment attribute. If \code{NULL},
the scope is not inspected.}
}
\description{
These predicates test for \link{quosure} objects.
\itemize{
\item \code{is_quosure()} tests for a tidyeval quosure. These are one-sided
formulas with a \code{quosure} class.
\item \code{is_quosureish()} tests for general R quosure objects: quosures,
or one-sided formulas.
}
}
\examples{
# Quosures are created with quo():
quo(foo)
is_quosure(quo(foo))

# Formulas look similar to quosures but are not quosures:
is_quosure(~foo)

# But they are quosureish:
is_quosureish(~foo)

# Note that two-sided formulas are never quosureish:
is_quosureish(a ~ b)
}
\seealso{
\code{\link[=is_formula]{is_formula()}} and \code{\link[=is_formulaish]{is_formulaish()}}
}
