% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-utils.R
\name{seq2}
\alias{seq2}
\alias{seq2_along}
\title{Increasing sequence of integers in an interval}
\usage{
seq2(from, to)

seq2_along(from, x)
}
\arguments{
\item{from}{The starting point of the sequence.}

\item{to}{The end point.}

\item{x}{A vector whose length is the end point.}
}
\value{
An integer vector containing a strictly increasing
sequence.
}
\description{
These helpers take two endpoints and return the sequence of all
integers within that interval. For \code{seq2_along()}, the upper
endpoint is taken from the length of a vector. Unlike
\code{base::seq()}, they return an empty vector if the starting point is
a larger integer than the end point.
}
\examples{
seq2(2, 10)
seq2(10, 2)
seq(10, 2)

seq2_along(10, letters)
}
