% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd.R
\name{cnd_signal}
\alias{cnd_signal}
\title{Signal a condition object}
\usage{
cnd_signal(cnd, .cnd, .mufflable)
}
\arguments{
\item{cnd}{A condition object (see \code{\link[=cnd]{cnd()}}).}

\item{.cnd, .mufflable}{These arguments are deprecated.}
}
\description{
The type of signal depends on the class of the condition:
\itemize{
\item A message is signalled if the condition inherits from
\code{"message"}. This is equivalent to signalling with \code{\link[=inform]{inform()}} or
\code{\link[base:message]{base::message()}}.
\item A warning is signalled if the condition inherits from
\code{"warning"}. This is equivalent to signalling with \code{\link[=warn]{warn()}} or
\code{\link[base:warning]{base::warning()}}.
\item An error is signalled if the condition inherits from
\code{"error"}. This is equivalent to signalling with \code{\link[=abort]{abort()}} or
\code{\link[base:stop]{base::stop()}}.
\item An interrupt is signalled if the condition inherits from
\code{"interrupt"}. This is equivalent to signalling with
\code{\link[=interrupt]{interrupt()}}.
}

Use \code{\link[=cnd_type]{cnd_type()}} to determine the type of a condition.
}
\section{Lifecycle}{

\itemize{
\item \code{.cnd} has been renamed to \code{cnd} and is deprecated as of rlang 0.3.0.
\item The \code{.mufflable} argument is deprecated as of rlang 0.3.0 and no
longer has any effect. Non-critical conditions are always
signalled with a muffle restart.
\item Creating a condition object with \code{\link[=cnd_signal]{cnd_signal()}} is deprecated as
of rlang 0.3.0. Please use \code{\link[=signal]{signal()}} instead.
}
}

\examples{
# The type of signal depends on the class. If the condition
# inherits from "warning", a warning is issued:
cnd <- warning_cnd("my_warning_class", message = "This is a warning")
cnd_signal(cnd)

# If it inherits from "error", an error is raised:
cnd <- error_cnd("my_error_class", message = "This is an error")
try(cnd_signal(cnd))
}
\seealso{
\code{\link[=abort]{abort()}}, \code{\link[=warn]{warn()}} and \code{\link[=inform]{inform()}} for creating and
signalling structured R conditions. See \code{\link[=with_handlers]{with_handlers()}} for
establishing condition handlers.
}
