% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-special.R
\name{caller_env}
\alias{caller_env}
\alias{current_env}
\title{Get the current or caller environment}
\usage{
caller_env(n = 1)

current_env()
}
\arguments{
\item{n}{Number of frames to go back.}
}
\description{
\itemize{
\item The current environment is the execution environment of the
current function (the one currently being evaluated).
\item The caller environment is the execution environment of the
function that called the current function.
}
}
\examples{
# Let's create a function that returns its current environment and
# its caller environment:
fn <- function() list(current = current_env(), caller = caller_env())

# The current environment is an unique execution environment
# created when `fn()` was called. The caller environment is the
# global env because that's where we called `fn()`.
fn()

# Let's call `fn()` again but this time within a function:
g <- function() fn()

# Now the caller environment is also a unique execution environment.
# This is the exec env created by R for our call to g():
g()
}
\seealso{
\code{\link[=caller_frame]{caller_frame()}} and \code{\link[=current_frame]{current_frame()}}
}
