% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deparse.R
\name{as_name}
\alias{as_name}
\title{Extract names from symbols}
\usage{
as_name(x)
}
\arguments{
\item{x}{A string or symbol, possibly wrapped in a \link{quosure}.
If a string, the attributes are removed, if any.}
}
\value{
A character vector of length 1.
}
\description{
\code{as_name()} converts \link[=sym]{symbols} to character strings. The
conversion is deterministic. That is, the roundtrip \code{symbol -> name -> symbol} always gives the same result.
\itemize{
\item Use \code{as_name()} when you need to transform a symbol to a string
to \emph{refer} to an object by its name.
\item Use \code{\link[=as_label]{as_label()}} when you need to transform any kind of object to
a string to \emph{represent} that object with a short description.
}

Expect \code{as_name()} to gain
\href{https://principles.tidyverse.org/names-attribute.html#minimal-unique-universal}{name-repairing}
features in the future.
}
\details{
\code{rlang::as_name()} is the \emph{opposite} of \code{\link[base:name]{base::as.name()}}. If
you're writing base R code, we recommend using \code{\link[base:name]{base::as.symbol()}}
which is an alias of \code{as.name()} that follows a more modern
terminology (R types instead of S modes).
}
\examples{
# Let's create some symbols:
foo <- quote(foo)
bar <- sym("bar")

# as_name() converts symbols to strings:
foo
as_name(foo)

typeof(bar)
typeof(as_name(bar))

# as_name() unwraps quosured symbols automatically:
as_name(quo(foo))
}
\seealso{
\code{\link[=as_label]{as_label()}} for converting any object to a single string
suitable as a label. \code{\link[=as_string]{as_string()}} for a lower-level version that
doesn't unwrap quosures.
}
