% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_scatter}
\alias{lc_scatter}
\alias{lc_beeswarm}
\title{Visualize a set of points}
\usage{
lc_scatter(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  with = NULL,
  addLayer = FALSE,
  pacerStep = 50
)

lc_beeswarm(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  with = NULL,
  addLayer = FALSE,
  pacerStep = 50
)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{ID of a container, where to place new chart. Will be ignored if the chart already
exists. If not defined, the chart will be appended to the body of the web pages.}

\item{...}{Name-value pairs of properties that will be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function.}

\item{chartId}{ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, it will be replaced unless \code{addLayer = TRUE}. If ID is not defined, it will be the same as
value of the \code{place} argument. And if both are not defined, the ID will be set to \code{ChartN},
where \code{N - 1} is the number of existing charts.}

\item{layerId}{An ID for the new layer. All layers within one chart must have different IDs. If a layer with the same
ID already exists, it will be replaced. If not defined, will be set to \code{LayerN}, where \code{N - 1}
is the number of currently existing layers in this chart.}

\item{with}{A data set from which other properties should be taken. If the data set doesn't have a
column with the requested name, the variable will be searched for outside of the data set. Must be
a data.frame or a list.}

\item{addLayer}{if there is already a chart with the same ID, this argument defines whether to replace it or to add a
new layer to it. This argument is ignored if both \code{place} and \code{chartId} are \code{NULL} or if there is no
chart with the given ID.}

\item{pacerStep}{Time in ms between two consecutive calls of an \code{onmouseover} event. Prevents overqueuing in case
of cumbersome computations. May be important when the chart works in canvas mode.}
}
\description{
These functions plot a set of points with known coordinates that can be either categorical,
or continuous.
}
\section{Functions}{
\itemize{
\item \code{lc_scatter}: creates a scatterplot and adds it as a new layer to an existing chart or
creates a new one.

\item \code{lc_beeswarm}: creates a special kind of scatterplot, where the points are spread along one of
the axes to avoid overlapping.
}}

\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{x, y} - vector of x and y coordinates of the points.
\item \code{size} - sizes of the points. Default size is 6.
\item \code{opacity} - opacity of each point in the range from 0 to 1.
\item \code{label} - vector of text labels for each point (labels by default are shown, when mouse hovers over a point).
\item \code{valueAxis} - (for \code{lc_beeswarm} only) defines axis with values that will
not be changed. Must be \code{"x"} or \code{"y"} (default).}

Colour and shape settings
\itemize{
\item \code{colour} - colour of the points. Must be a colour name or hexadecimal code.
\item \code{colourValue} - grouping values for different colours. Can be numbers or characters.
\item \code{colourDomain} - vector of all possible values for discrete colour scales
or range of all possible colour values for the continuous ones.
\item \code{palette} - vector of colours to construct the colour scale.
\item \code{colourLegendTitle} - title for the colour legend.
\item \code{addColourScaleToLegend} - whether or not to show colour legend for the current layer.
\item \code{globalColourScale} - whether or not to use one colour scale for all the layers.
\item \code{symbol} - shape of each point. Must be one of \code{"Circle"}, \code{"Cross"}, \code{"Diamond"},
\code{"Square"}, \code{"Star"}, \code{"Triangle"}, \code{"Wye"}.
\item \code{symbolValue} - grouping values for different symbols.
\item \code{symbolLegendTitle} - title for the symbol value.
\item \code{stroke} - stroke colour for each element. Must be a colour name or hexadecimal code.
\item \code{strokeWidth} - width of the strokes for each point.}

Axes settings
\itemize{
\item \code{logScaleX, logScaleY} - a base of logarithm for logarithmic scale transformation.
If 0 or \code{FALSE} no transformation will be performed.
\item \code{jitterX, jitterY} - amount of random variation to be added to the position of the
points along one of the axes. 0 means no variation. 1 stands for distance between \code{x} and
\code{x + 1} for linear scale, \code{x} and \code{b*x} for logarithmic scale (\code{b} is a base
of the logarithm), or between neighbouring ticks for categorical scale.
\item \code{shiftX, shiftY} - shift for each point from its original position along one of the
axes. 0 means no shift. 1 stands for distance between \code{x} and
\code{x + 1} for linear scale, \code{x} and \code{b*x} for logarithmic scale (\code{b} is a base
of the logarithm), or between neighbouring ticks for categorical scale.
\item \code{layerDomainX, layerDomainY} - default axes ranges for the given layer.
\item \code{domainX, domainY} - default axes ranges for the entire chart. If not defined,
is automatically set to include all layer domains.
\item \code{contScaleX, contScaleY} - whether or not the axis should be continuous.
\item \code{aspectRatio} - aspect ratio.
\item \code{axisTitleX, axisTitleY} - axes titles.
\item \code{axisTitlePosX, axisTitlePosY} - position of axes titles. For each axis one can specify title position
across or along the corresponding axis. Possible options are \code{"up"} (for title inside the plotting area)
or \code{"down"} (outside the plotting area, under the axis), and
\code{"start"}, \code{"middle"}, \code{"end"}. This property must be a string with one or two of the aforementioned options
(e.g. \code{"middle down"}, \code{"start"}, etc.).
\item \code{ticksRotateX, ticksRotateY} - angle by which to rotate ticks (in degrees). Must be between
0 (horizontal ticks, default) and 90 (vertical ticks).
\item \code{ticksX, ticksY} - set of ticks for the axes.}

Interactivity settings
\itemize{
\item \code{on_click} - function, to be called, when one of the points is clicked. Gets an
index of the clicked point as an argument.
\item \code{on_positionClick} - function, to be called, when any point of the chart is clicked. Unlike
\code{on_click} which is called only when an element of the chart (point, line, etc.) is clicked, this
function reacts to any click on the chart. As an argument it receives a vector of x and y coordinates of
the click (based on the current axes scales). If one of the axes is categorical, then the function will
get the closest tick to the clicked position.
\item \code{on_mouseover} - function, to be called, when mouse hovers over one of the points.
Gets an index of the clicked point as an argument.
\item \code{on_mouseout} - function, to be called, when mouse moves out of one of the points.
\item \code{on_marked} - function, to be called, when any of the points are selected (marked)
or deselected. Use \code{\link{getMarked}} function to get the IDs of the currently marked points. To mark points,
select them with your mouse while holding the \emph{Shift} key.}

Global chart settings
\itemize{
\item \code{width} - width of the chart in pixels.
\item \code{heigth} - height of the chart in pixels.
\item \code{plotWidth} - width of the plotting area in pixels.
\item \code{plotHeight} - height of the plotting area in pixels.
\item \code{paddings} - padding sizes in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.
\item \code{title} - title of the chart.
\item \code{titleX, titleY} - coordinates of the chart title.
\item \code{titleSize} - font-size of the chart title.
\item \code{showLegend} - whether or not to show the legend.
\item \code{showPanel} - whether of not to show the instrument panel (gray triangle in the upper-left corner of the chart).
\item \code{transitionDuration} - duration of the transitions between any two states of the chart. If 0,
no animated transition is shown. It can be useful to turn the transition off, when lots of frequent
changes happen to the chart.}
}

\examples{
\donttest{data("iris")
lc_scatter(dat(x = Sepal.Length, 
               y = Petal.Length,
               colourValue = Petal.Width,
               symbolValue = Species),
           with = iris,
           title = "Iris dataset",
           axisTitleY = "Petal Length",
           axisTitleX = "Sepal Length",
           colourLegendTitle = "Petal Width",
           symbolLegendTitle = "Species")

lc_beeswarm(dat(x = iris$Species,
                y = iris$Sepal.Length,
                colourValue = iris$Sepal.Width),
            title = "Iris dataset",
            axisTitleY = "Sepal Length",
            axisTitleX = "Species",
            colourLegendTitle = "Sepal Width")}
}
