% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxflow.R
\name{MaxFlow}
\alias{MaxFlow}
\title{MaxFlow}
\usage{
MaxFlow(
  arcSources,
  arcTargets,
  arcCapacities,
  sourceNode,
  destNode,
  numNodes,
  algorithm
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcCapacities}{Vector corresponding to the capacities of nodes of a
graph's edges}

\item{sourceNode}{The source node}

\item{destNode}{The destination node}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Which algorithm to run. Choices include "Preflow",
"EdmondsKarp", where "Preflow" is the default. See
<https://lemon.cs.elte.hu/pub/doc/1.3.1/a00611.html> for details on the
differences.}
}
\value{
A list containing three entries: 1) A list corresponding to the
  flows of arcs in the graph, 2) A list of cut-values of the graph's nodes,
  and 3) the total cost of the flows in the graph, i.e. the maxflow value.
}
\description{
Finds the maximum flow of a directed graph, given a source and destination node.
}
